/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.screen.components.GenericMonitorSelectionList;
import whocraft.tardis_refined.client.screen.components.SelectionListEntry;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.common.network.messages.C2SChangeShell;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;

public class ShellSelectionScreen
extends MonitorOS.MonitorOSExtension {
    private static ShellPattern PATTERN = ShellPatterns.DEFAULT;
    private Button patternButton;

    public ShellSelectionScreen(ResourceLocation currentShellTheme) {
        super((Component)Component.m_237115_((String)ModMessages.UI_EXTERNAL_SHELL), currentShellTheme);
    }

    @Override
    public ResourceLocation getPatternForRender() {
        return PATTERN.id();
    }

    @Override
    protected void m_7856_() {
        boolean themeHasPatterns;
        super.m_7856_();
        this.setEvents(() -> this.selectShell(CURRENTSHELLTHEME), () -> {
            if (this.PREVIOUS != null) {
                this.switchScreenToLeft(this.PREVIOUS);
            }
        });
        int vPos = (this.f_96544_ - 130) / 2;
        this.addSubmitButton(this.f_96543_ / 2 + 90, this.f_96544_ - vPos - 25);
        this.addCancelButton(this.f_96543_ / 2 - 11, this.f_96544_ - vPos - 25);
        this.patternButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), button -> {
            PATTERN = ShellPatterns.next(PATTERNCOLLECTION, PATTERN);
            button.m_93666_((Component)Component.Serializer.m_130699_((StringReader)new StringReader(PATTERN.name())));
        }).m_252794_(this.f_96543_ / 2 + 14, this.f_96544_ - vPos - 25).m_253046_(70, 20).m_253136_());
        this.patternButton.f_93624_ = themeHasPatterns = PATTERNCOLLECTION.size() > 1;
        if (themeHasPatterns) {
            this.patternButton.m_93666_((Component)Component.Serializer.m_130699_((StringReader)new StringReader(PATTERN.name())));
        }
    }

    @Override
    public void renderBackdrop(@NotNull GuiGraphics guiGraphics) {
        super.renderBackdrop(guiGraphics);
        PoseStack poseStack = guiGraphics.m_280168_();
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        poseStack.m_85836_();
        int b = this.f_96544_ - vPos;
        int r = this.f_96543_ - hPos;
        int l1 = hPos + 57;
        int l2 = hPos + 115;
        guiGraphics.m_280509_(l2, vPos, r, b, -1072689136);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        poseStack.m_252880_((float)(-this.f_96544_), 0.0f, 0.0f);
        guiGraphics.m_280024_(vPos, l1, b, l2, 0, -1072689136);
        poseStack.m_85849_();
    }

    @Override
    public void inMonitorRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderShell(guiGraphics, this.f_96543_ / 2 - 70, this.f_96544_ / 2 - 5, 25.0f);
    }

    public GenericMonitorSelectionList<SelectionListEntry> createSelectionList() {
        int leftPos = this.f_96543_ / 2;
        int topPos = (this.f_96544_ - 130) / 2;
        GenericMonitorSelectionList<SelectionListEntry> selectionList = new GenericMonitorSelectionList<SelectionListEntry>(this.f_96541_, 105, 80, leftPos, topPos + 15, topPos + 130 - 30, 12);
        selectionList.m_93488_(false);
        List<Object> values = ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.entrySet().stream().toList();
        values = values.stream().sorted(Comparator.comparing(theme -> ((ShellTheme)theme.getValue()).getDisplayName().toString())).toList();
        for (Map.Entry entry2 : values) {
            ResourceLocation shellThemeId = ShellTheme.getKey((ShellTheme)entry2.getValue());
            String owner = Platform.getModName(((ResourceKey)entry2.getKey()).m_135782_().m_135827_());
            MutableComponent tooltip = Component.m_237113_((String)(ChatFormatting.BLUE + owner));
            SelectionListEntry selectionListEntry = new SelectionListEntry(((ShellTheme)entry2.getValue()).getDisplayName(), entry -> {
                boolean themeHasPatterns;
                CURRENTSHELLTHEME = shellThemeId;
                for (Object child : selectionList.m_6702_()) {
                    if (!(child instanceof SelectionListEntry)) continue;
                    SelectionListEntry current = (SelectionListEntry)((Object)((Object)((Object)child)));
                    current.setChecked(false);
                }
                PATTERNCOLLECTION = ShellPatterns.getPatternCollectionForTheme(CURRENTSHELLTHEME);
                PATTERN = (ShellPattern)PATTERNCOLLECTION.get(0);
                this.patternButton.f_93624_ = themeHasPatterns = PATTERNCOLLECTION.size() > 1;
                if (themeHasPatterns) {
                    this.patternButton.m_93666_((Component)Component.Serializer.m_130699_((StringReader)new StringReader(PATTERN.name())));
                }
                entry.setChecked(true);
            }, leftPos);
            selectionListEntry.setTooltip((Component)tooltip);
            if (CURRENTSHELLTHEME.toString().equals(shellThemeId.toString())) {
                selectionListEntry.setChecked(true);
            }
            selectionList.m_6702_().add(selectionListEntry);
        }
        return selectionList;
    }

    public void selectShell(ResourceLocation themeId) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        new C2SChangeShell((ResourceKey<Level>)Minecraft.m_91087_().f_91074_.m_9236_().m_46472_(), themeId, PATTERN).send();
    }
}

