/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.shell;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.common.block.shell.GlobalShellBlock;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.blockentity.shell.ShellBaseBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.dimension.DimensionHandler;
import whocraft.tardis_refined.common.items.KeyItem;
import whocraft.tardis_refined.common.tardis.manager.AestheticHandler;
import whocraft.tardis_refined.common.tardis.manager.TardisExteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;
import whocraft.tardis_refined.patterns.sound.ConfiguredSound;
import whocraft.tardis_refined.patterns.sound.TRShellSoundProfiles;
import whocraft.tardis_refined.registry.TRBlockEntityRegistry;

public class GlobalShellBlockEntity
extends ShellBaseBlockEntity {
    private ResourceLocation shellTheme = ShellTheme.HALF_BAKED.getId();
    private ShellPattern basePattern = this.pattern();

    public GlobalShellBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TRBlockEntityRegistry.GLOBAL_SHELL_BLOCK.get(), blockPos, blockState);
    }

    public ResourceLocation theme() {
        if (this.shellTheme == null) {
            this.shellTheme = ShellTheme.HALF_BAKED.getId();
        }
        return this.shellTheme;
    }

    public ResourceLocation getShellTheme() {
        return this.shellTheme;
    }

    public void setShellTheme(ResourceLocation theme) {
        this.shellTheme = theme;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public ShellPattern pattern() {
        return this.basePattern == null ? ShellPatterns.DEFAULT : this.basePattern;
    }

    public GlobalShellBlockEntity setPattern(ShellPattern basePattern) {
        this.basePattern = basePattern;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return this;
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        ResourceLocation currentPattern;
        super.m_142466_(pTag);
        if (pTag.m_128441_("theme")) {
            ResourceLocation themeId;
            this.shellTheme = themeId = new ResourceLocation(pTag.m_128461_("theme"));
        }
        if (pTag.m_128441_("pattern") && this.shellTheme != null && ShellPatterns.doesPatternExist(this.shellTheme, currentPattern = new ResourceLocation(pTag.m_128461_("pattern")))) {
            this.basePattern = ShellPatterns.getPatternOrDefault(this.shellTheme, currentPattern);
        }
        if (this.shellTheme == null) {
            this.shellTheme = this.theme();
        }
        if (this.basePattern == null) {
            this.basePattern = this.pattern();
        }
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.shellTheme != null) {
            pTag.m_128359_("theme", this.shellTheme.toString());
        }
        if (this.basePattern != null) {
            pTag.m_128359_("pattern", this.basePattern.id().toString());
        }
    }

    public boolean onRightClick(BlockState blockState, ItemStack stack, Level level, BlockPos blockPos, Player player) {
        ServerLevel serverLevel;
        ServerLevel interior;
        Optional<TardisLevelOperator> tardisLevelOperatorOptional;
        if (((Boolean)blockState.m_61143_((Property)ShellBaseBlock.REGEN)).booleanValue()) {
            return false;
        }
        if (level instanceof ServerLevel && (tardisLevelOperatorOptional = TardisLevelOperator.get(interior = DimensionHandler.getExistingLevel(serverLevel = (ServerLevel)level, (ResourceKey<Level>)this.TARDIS_ID))).isPresent()) {
            TardisLevelOperator tardisLevelOperator = tardisLevelOperatorOptional.get();
            TardisPilotingManager tardisPilotingManager = tardisLevelOperator.getPilotingManager();
            AestheticHandler aestheticHandler = tardisLevelOperator.getAestheticHandler();
            TardisExteriorManager exteriorManager = tardisLevelOperator.getExteriorManager();
            if (tardisPilotingManager.isInFlight()) {
                return false;
            }
            if (stack.m_150930_(Items.f_42574_) && aestheticHandler.getShellTheme() == ShellTheme.HALF_BAKED.getId()) {
                aestheticHandler.setShellTheme(ShellTheme.FACTORY.getId(), ShellPatterns.DEFAULT.id(), tardisPilotingManager.getCurrentLocation());
                level.m_5594_(null, blockPos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.spawnCoralItems();
                return true;
            }
            boolean validKey = KeyItem.keychainContains(stack, (ResourceKey<Level>)this.TARDIS_ID);
            boolean locked = exteriorManager.locked();
            if (validKey) {
                tardisLevelOperator.setDoorLocked(!locked);
                tardisLevelOperator.setDoorClosed(!locked);
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)(exteriorManager.locked() ? ModMessages.DOOR_LOCKED : ModMessages.DOOR_UNLOCKED)), true);
                return true;
            }
            if (locked) {
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.DOOR_LOCKED), true);
                return true;
            }
            if (!exteriorManager.locked()) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61122_((Property)GlobalShellBlock.OPEN), 3);
                tardisLevelOperator.setDoorClosed((Boolean)blockState.m_61143_((Property)GlobalShellBlock.OPEN));
                return true;
            }
        }
        return false;
    }

    public void sendUpdates() {
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        this.m_6596_();
    }

    public void spawnCoralItems() {
        int numberOfItems = 2 + this.f_58857_.m_213780_().m_188503_(5);
        for (int i = 0; i < numberOfItems; ++i) {
            ItemStack coralItem = new ItemStack((ItemLike)Items.f_42357_);
            BlockPos currentPos = this.m_58899_();
            Containers.m_18992_((Level)this.f_58857_, (double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), (ItemStack)coralItem);
        }
    }

    @Override
    public void playDoorCloseSound(boolean closeDoor) {
        ShellPattern pattern = this.pattern();
        if (pattern != null) {
            ConfiguredSound configuredSound;
            Level currentLevel = this.m_58904_();
            if (closeDoor) {
                configuredSound = pattern.soundProfile().get() != null ? pattern.soundProfile().get().getDoorClose() : TRShellSoundProfiles.DEFAULT_SOUND_PROFILE.getDoorClose();
            } else {
                ConfiguredSound configuredSound2 = configuredSound = pattern.soundProfile().get() != null ? pattern.soundProfile().get().getDoorOpen() : TRShellSoundProfiles.DEFAULT_SOUND_PROFILE.getDoorOpen();
            }
            if (configuredSound != null) {
                currentLevel.m_5594_(null, this.m_58899_(), configuredSound.getSoundEvent(), SoundSource.BLOCKS, configuredSound.getPitch(), configuredSound.getVolume());
            }
        }
    }

    @Override
    public void playDoorLockedSound(boolean lockDoor) {
        ShellPattern pattern = this.pattern();
        if (pattern != null) {
            ConfiguredSound configuredSound;
            Level currentLevel = this.m_58904_();
            if (lockDoor) {
                configuredSound = pattern.soundProfile().get() != null ? pattern.soundProfile().get().getDoorLocked() : TRShellSoundProfiles.DEFAULT_SOUND_PROFILE.getDoorLocked();
            } else {
                ConfiguredSound configuredSound2 = configuredSound = pattern.soundProfile().get() != null ? pattern.soundProfile().get().getDoorUnlocked() : TRShellSoundProfiles.DEFAULT_SOUND_PROFILE.getDoorUnlocked();
            }
            if (configuredSound != null) {
                currentLevel.m_5594_(null, this.m_58899_(), configuredSound.getSoundEvent(), SoundSource.BLOCKS, configuredSound.getPitch(), configuredSound.getVolume());
            }
        }
    }
}

