/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages;

import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.manager.TardisInteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class C2SChangeDesktop
extends MessageC2S {
    private final ResourceKey<Level> resourceKey;
    private final DesktopTheme desktopTheme;

    public C2SChangeDesktop(ResourceKey<Level> tardisLevel, DesktopTheme theme) {
        this.resourceKey = tardisLevel;
        this.desktopTheme = theme;
    }

    public C2SChangeDesktop(FriendlyByteBuf buffer) {
        this.resourceKey = buffer.m_236801_(Registries.f_256858_);
        this.desktopTheme = TardisDesktops.getDesktopById(buffer.m_130281_());
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.CHANGE_DESKTOP;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236858_(this.resourceKey);
        buf.m_130085_(this.desktopTheme.getIdentifier());
    }

    @Override
    public void handle(MessageContext context) {
        Optional<ServerLevel> level = Optional.ofNullable((ServerLevel)context.getPlayer().m_20194_().f_129762_.get(this.resourceKey));
        level.ifPresent(x -> TardisLevelOperator.get(x).ifPresent(operator -> {
            TardisPilotingManager pilotManager = operator.getPilotingManager();
            TardisInteriorManager interiorManager = operator.getInteriorManager();
            boolean inFlight = pilotManager.isInFlight();
            boolean hasFuel = interiorManager.hasEnoughFuel();
            if (!inFlight && hasFuel) {
                interiorManager.prepareDesktop(this.desktopTheme);
                pilotManager.removeFuel(interiorManager.getRequiredFuel());
            } else {
                if (inFlight) {
                    x.m_6269_(null, (Entity)context.getPlayer(), TRSoundRegistry.TARDIS_SINGLE_FLY.get(), SoundSource.BLOCKS, 10.0f, 0.25f);
                }
                if (!hasFuel) {
                    x.m_6269_(null, (Entity)context.getPlayer(), TRSoundRegistry.SCREWDRIVER_CONNECT.get(), SoundSource.BLOCKS, 10.0f, 0.25f);
                    PlayerUtil.sendMessage((LivingEntity)context.getPlayer(), ModMessages.NO_DESKTOP_NO_FUEL, true);
                }
            }
        }));
    }
}

