/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.player;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.player.TardisPlayerInfo;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;

public class SyncTardisPlayerInfoMessage
extends MessageS2C {
    public int entityID;
    public CompoundTag nbt;

    public SyncTardisPlayerInfoMessage(int entityID, CompoundTag nbt) {
        this.entityID = entityID;
        this.nbt = nbt;
    }

    public SyncTardisPlayerInfoMessage(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.nbt = buf.m_130260_();
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.TARDIS_PLAYER_INFO;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130079_(this.nbt);
    }

    @Override
    public void handle(MessageContext context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(this.entityID);
        if (entity != null) {
            TardisPlayerInfo.get((LivingEntity)((Player)entity)).ifPresent(c -> c.loadData(this.nbt));
        }
    }
}

