/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.sync;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;

public class S2CSyncHums
extends MessageS2C {
    private static final Codec<Map<ResourceLocation, HumEntry>> MAPPER = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, HumEntry.codec());
    private Map<ResourceLocation, HumEntry> tardisHums = new HashMap<ResourceLocation, HumEntry>();

    public S2CSyncHums(Map<ResourceLocation, HumEntry> tardisHums) {
        this.tardisHums = tardisHums;
    }

    public S2CSyncHums(FriendlyByteBuf buf) {
        this.tardisHums = MAPPER.parse((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).result().orElse(TardisHums.registerDefaultHums());
    }

    @Override
    public MessageType getType() {
        return TardisNetwork.SYNC_HUMS;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(MAPPER.encodeStart((DynamicOps)NbtOps.f_128958_, this.tardisHums).result().orElse(new CompoundTag()));
    }

    @Override
    public void handle(MessageContext context) {
        TardisHums.getRegistry().clear();
        for (Map.Entry<ResourceLocation, HumEntry> entry : this.tardisHums.entrySet()) {
            TardisHums.getRegistry().put(entry.getKey(), entry.getValue());
        }
    }
}

