/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.control.flight;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRUpgrades;

public class DimensionalControl
extends Control {
    public DimensionalControl(ResourceLocation id) {
        super(id);
    }

    public DimensionalControl(ResourceLocation id, String langId) {
        super(id, langId);
    }

    private List<ServerLevel> getAllowedDimensions(TardisLevelOperator tardisLevelOperator) {
        ArrayList filteredDimensions = new ArrayList();
        Iterable filteredLevels = Platform.getServer().m_129785_();
        filteredLevels.forEach(x -> {
            if (tardisLevelOperator.getProgressionManager().isLevelDiscovered((ResourceKey<Level>)x.m_46472_())) {
                filteredDimensions.add(x);
            }
        });
        return filteredDimensions.stream().filter(serverLevel -> DimensionUtil.isAllowedDimension((ResourceKey<Level>)serverLevel.m_46472_())).toList();
    }

    @Override
    public boolean onLeftClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        return this.changeDim(operator, theme, controlEntity, player, false);
    }

    @Override
    public boolean onRightClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        return this.changeDim(operator, theme, controlEntity, player, true);
    }

    private boolean changeDim(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player, boolean forward) {
        if (!operator.getLevel().m_5776_()) {
            int nextIndex;
            TardisPilotingManager pilotManager = operator.getPilotingManager();
            UpgradeHandler upgradeHandler = operator.getUpgradeHandler();
            if (!TRUpgrades.DIMENSION_TRAVEL.get().isUnlocked(upgradeHandler)) {
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.HARDWARE_OFFLINE), true);
                pilotManager.getTargetLocation().setDimensionKey((ResourceKey<Level>)Level.f_46428_);
                return false;
            }
            List<ServerLevel> dimensions = this.getAllowedDimensions(operator);
            int currentIndex = dimensions.indexOf(pilotManager.getTargetLocation().getLevel());
            int n = forward ? (currentIndex >= dimensions.size() - 1 ? 0 : currentIndex + 1) : (nextIndex = currentIndex <= 0 ? dimensions.size() - 1 : currentIndex - 1);
            if (dimensions.isEmpty()) {
                return false;
            }
            ServerLevel nextDimension = dimensions.get(nextIndex);
            if (nextDimension.m_46472_() == Level.f_46430_ && pilotManager.isInFlight() && !TardisHelper.hasTheEndBeenCompleted(nextDimension)) {
                nextIndex += forward ? 1 : -1;
            }
            pilotManager.setTargetDimension(dimensions.get(nextIndex));
            PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237110_((String)ModMessages.CONTROL_DIMENSION_SELECTED, (Object[])new Object[]{MiscHelper.getCleanDimensionName(pilotManager.getTargetLocation().getDimensionKey())}), true);
            if (pilotManager.isInFlight()) {
                operator.getPilotingManager().recalculateFlightDistance();
            }
            return true;
        }
        return false;
    }
}

