/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class LevelHelper {
    public static Vec3 centerPos(BlockPos pos, boolean centerY) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + (centerY ? 0.5 : 0.0), (double)pos.m_123343_() + 0.5);
    }

    public static float getAdjustedRotation(float rot) {
        float newR = rot % 360.0f;
        if (newR < 0.0f) {
            return 360.0f + newR;
        }
        return newR;
    }

    public static float getAngleFromDirection(Direction dir) {
        switch (dir) {
            case EAST: {
                return 90.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public static List<BlockPos> getBlockPosInRadius(BlockPos referencePoint, int radius, boolean interCardinal, boolean includeReferencePoint) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        ArrayList horizontalDirections = new ArrayList();
        horizontalDirections.addAll(Direction.Plane.HORIZONTAL.m_122557_().toList());
        for (Direction dir : horizontalDirections) {
            BlockPos offsettedPos = referencePoint.m_5484_(dir, radius);
            posList.add(offsettedPos);
            if (!interCardinal) continue;
            BlockPos interCardinalPos = offsettedPos.m_121955_(dir.m_122427_().m_122436_());
            posList.add(interCardinalPos);
        }
        if (includeReferencePoint) {
            posList.add(referencePoint);
        }
        return posList;
    }
}

