/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns.forge;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.NetworkManager;
import whocraft.tardis_refined.patterns.BasePattern;
import whocraft.tardis_refined.patterns.PatternCollection;
import whocraft.tardis_refined.patterns.PatternReloadListener;

public class PatternReloadListenerImpl {
    public static <P extends PatternCollection, B extends BasePattern> PatternReloadListener<P, B> createListener(String folderName, Codec<P> codec, Function<List<P>, List<B>> merger) {
        return new Impl(folderName, codec, merger);
    }

    public static class Impl<T extends PatternCollection, B extends BasePattern>
    extends PatternReloadListener<T, B> {
        public Impl(String folderName, Codec<T> codec, Function<List<T>, List<B>> merger) {
            super(folderName, codec, merger);
        }

        public PatternReloadListener setSyncPacket(NetworkManager networkManager, Function packetFactory) {
            MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(networkManager, packetFactory));
            return this;
        }

        private Consumer<OnDatapackSyncEvent> getDatapackSyncListener(NetworkManager networkManager, Function<Map<ResourceLocation, List<B>>, MessageS2C> packetFactory) {
            return event -> this.handleSyncPacket(event.getPlayer(), networkManager, packetFactory);
        }
    }
}

