/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.patterns.PatternResourceConstants;
import whocraft.tardis_refined.patterns.sound.ConsoleSound;

public class ConsoleSoundProfile {
    private static final UnboundedMapCodec<ResourceLocation, ConsoleSound> UNBOUNDED_MAP_CODEC = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, ConsoleSound.CODEC);
    public static final Codec<ConsoleSoundProfile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UNBOUNDED_MAP_CODEC.fieldOf("sounds").forGetter(ConsoleSoundProfile::getSoundEntries)).apply((Applicative)instance, ConsoleSoundProfile::new));
    protected Map<ResourceLocation, ConsoleSound> consoleSoundEntries = new HashMap<ResourceLocation, ConsoleSound>();

    public ConsoleSoundProfile(Map<ResourceLocation, ConsoleSound> consoleSoundEntries) {
        this.consoleSoundEntries = consoleSoundEntries;
    }

    public ConsoleSoundProfile() {
        this(new HashMap<ResourceLocation, ConsoleSound>());
    }

    public Map<ResourceLocation, ConsoleSound> getSoundEntries() {
        return this.consoleSoundEntries;
    }

    public ConsoleSound getThrottleEnable() {
        return this.consoleSoundEntries.get(PatternResourceConstants.THROTTLE_ENABLE_KEY);
    }

    public ConsoleSoundProfile setThrottleEnable(ConsoleSound throttleEnable) {
        this.consoleSoundEntries.put(PatternResourceConstants.THROTTLE_ENABLE_KEY, throttleEnable);
        return this;
    }

    public ConsoleSound getThrottleDisable() {
        return this.consoleSoundEntries.get(PatternResourceConstants.THROTTLE_DISABLE_KEY);
    }

    public ConsoleSoundProfile setThrottleDisable(ConsoleSound throttleDisable) {
        this.consoleSoundEntries.put(PatternResourceConstants.THROTTLE_DISABLE_KEY, throttleDisable);
        return this;
    }

    public ConsoleSound getHandbrakeEnable() {
        return this.consoleSoundEntries.get(PatternResourceConstants.HANDBRAKE_ENABLE_KEY);
    }

    public ConsoleSoundProfile setHandbrakeEnable(ConsoleSound handbrakeEnable) {
        this.consoleSoundEntries.put(PatternResourceConstants.HANDBRAKE_ENABLE_KEY, handbrakeEnable);
        return this;
    }

    public ConsoleSound getHandbrakeDisable() {
        return this.consoleSoundEntries.get(PatternResourceConstants.HANDBRAKE_DISABLE_KEY);
    }

    public ConsoleSoundProfile setHandbrakeDisable(ConsoleSound handbrakeDisable) {
        this.consoleSoundEntries.put(PatternResourceConstants.HANDBRAKE_DISABLE_KEY, handbrakeDisable);
        return this;
    }

    public ConsoleSound getGeneric() {
        return this.consoleSoundEntries.get(PatternResourceConstants.GENERIC_CONSOLE_KEY);
    }

    public ConsoleSoundProfile setGeneric(ConsoleSound generic) {
        this.consoleSoundEntries.put(PatternResourceConstants.GENERIC_CONSOLE_KEY, generic);
        return this;
    }
}

