/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.villager;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.villager.VillagerDuck;

public class FlyTardisAtPOI
extends WorkAtPoi {
    public static final int EMERALD_FLIGHT_TIME = 6000;
    private Direction direction = Direction.NORTH;

    public void rotateDirection() {
        switch (this.direction) {
            case NORTH: {
                this.direction = Direction.EAST;
                break;
            }
            case EAST: {
                this.direction = Direction.SOUTH;
                break;
            }
            case SOUTH: {
                this.direction = Direction.WEST;
                break;
            }
            case WEST: {
                this.direction = Direction.NORTH;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid direction: " + this.direction);
            }
        }
    }

    protected boolean m_6114_(ServerLevel serverLevel, Villager villager) {
        GlobalPos globalPos = villager.m_6274_().m_21952_(MemoryModuleType.f_26360_).orElse(null);
        TardisLevelOperator tardisLevelOperator = TardisLevelOperator.get(serverLevel).orElse(null);
        if (globalPos == null || tardisLevelOperator == null) {
            return false;
        }
        VillagerDuck villagerDuck = (VillagerDuck)villager;
        return villagerDuck.tardisRefined$getPilotingTicks() > 0 && tardisLevelOperator.getPilotingManager().isInFlight() && !tardisLevelOperator.getPilotingManager().isCrashing() && globalPos.m_122640_() == serverLevel.m_46472_();
    }

    protected void m_5628_(ServerLevel serverLevel, Villager villager) {
        TardisLevelOperator.get(serverLevel).ifPresent(tardisLevelOperator -> {
            TardisPilotingManager pilotManager = tardisLevelOperator.getPilotingManager();
            GlobalConsoleBlockEntity console = pilotManager.getCurrentConsole();
            if (console == null) {
                return;
            }
            if (pilotManager.isInFlight()) {
                for (ControlEntity controlEntity : console.getControlEntityList()) {
                    if (!controlEntity.isTickingDown()) continue;
                    this.rotateDirection();
                    if (!controlEntity.m_9236_().f_46441_.m_188499_()) continue;
                    for (int i = 0; i < 5; ++i) {
                        controlEntity.realignControl();
                    }
                    villager.m_35310_();
                    return;
                }
            }
        });
        super.m_5628_(serverLevel, villager);
    }

    protected void m_6735_(ServerLevel serverLevel, Villager villager, long l) {
        Brain brain = villager.m_6274_();
        brain.m_21879_(MemoryModuleType.f_26330_, (Object)l);
        brain.m_21952_(MemoryModuleType.f_26360_).ifPresent(globalPos -> {
            BlockPos position = globalPos.m_122646_().m_5484_(this.direction, 2);
            brain.m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(position));
            villager.m_21573_().m_26519_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 1.0);
            villager.m_21563_().m_24946_((double)globalPos.m_122646_().m_123341_(), (double)globalPos.m_122646_().m_123342_(), (double)globalPos.m_122646_().m_123343_());
        });
        if (villager.f_19797_ % 80 == 0) {
            this.rotateDirection();
        }
        this.m_5628_(serverLevel, villager);
    }

    protected boolean m_6737_(ServerLevel serverLevel, Villager villager, long l) {
        Optional optional = villager.m_6274_().m_21952_(MemoryModuleType.f_26360_);
        TardisLevelOperator tardisLevelOperator = TardisLevelOperator.get(serverLevel).orElse(null);
        VillagerDuck villagerDuck = (VillagerDuck)villager;
        if (optional.isEmpty()) {
            return false;
        }
        GlobalPos globalPos = (GlobalPos)optional.get();
        return villagerDuck.tardisRefined$getPilotingTicks() > 0 && tardisLevelOperator.getPilotingManager().isInFlight() && tardisLevelOperator.getPilotingManager().isCrashing() && globalPos.m_122640_() == serverLevel.m_46472_() && globalPos.m_122646_().m_203195_((Position)villager.m_20182_(), 1.73);
    }
}

