/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.forge.registry;

import dev.obscuria.fragmentum.forge.registry.ForgeNetworking;
import dev.obscuria.fragmentum.network.PayloadRegistrar;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public record ForgePayloadRegistrar(String modId) implements PayloadRegistrar
{
    @Override
    public void allowClientOnly() {
        ForgeNetworking.clientOnlyMods.add(this.modId);
    }

    @Override
    public void allowServerOnly() {
        ForgeNetworking.serverOnlyMods.add(this.modId);
    }

    @Override
    public <T> void registerClientbound(Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<Player, T> handler) {
        SimpleChannel channel = ForgeNetworking.getOrCreateChannel(this.modId);
        ForgeNetworking.channelByType.put(clazz, channel);
        channel.messageBuilder(clazz, ForgeNetworking.nextIdFor(this.modId), NetworkDirection.PLAY_TO_CLIENT).encoder(encoder).decoder(decoder).consumerMainThread((payload, context) -> {
            ForgeNetworking.replyContext = (NetworkEvent.Context)context.get();
            handler.accept((Player)Minecraft.m_91087_().f_91074_, (Object)payload);
            ForgeNetworking.replyContext = null;
        }).add();
    }

    @Override
    public <T> void registerServerbound(Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<ServerPlayer, T> handler) {
        SimpleChannel channel = ForgeNetworking.getOrCreateChannel(this.modId);
        ForgeNetworking.channelByType.put(clazz, channel);
        channel.messageBuilder(clazz, ForgeNetworking.nextIdFor(this.modId), NetworkDirection.PLAY_TO_SERVER).encoder(encoder).decoder(decoder).consumerMainThread((payload, context) -> {
            ForgeNetworking.replyContext = (NetworkEvent.Context)context.get();
            handler.accept(((NetworkEvent.Context)context.get()).getSender(), payload);
            ForgeNetworking.replyContext = null;
        }).add();
    }
}

