/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.integration.jei;

import com.yablon.furnitury.integration.jei.FurnitureWorkbenchRecipeCategory;
import com.yablon.furnitury.integration.jei.GrillRecipeCategory;
import com.yablon.furnitury.integration.jei.KitchenFurnaceRecipeCategory;
import com.yablon.furnitury.integration.jei.MicrowaveRecipeCategory;
import com.yablon.furnitury.integration.jei.WaterCoolerRecipeCategory;
import com.yablon.furnitury.recipe.FurnitureWorkbenchRecipe;
import com.yablon.furnitury.recipe.GrillRecipe;
import com.yablon.furnitury.recipe.KitchenFurnaceRecipe;
import com.yablon.furnitury.recipe.MicrowaveRecipe;
import com.yablon.furnitury.recipe.WaterCoolerRecipe;
import com.yablon.furnitury.screen.FurnitureWorkbenchScreen;
import com.yablon.furnitury.screen.GrillScreen;
import com.yablon.furnitury.screen.KitchenFurnaceScreen;
import com.yablon.furnitury.screen.MicrowaveScreen;
import com.yablon.furnitury.screen.WaterCoolerScreen;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fml.ModList;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("furnitury", "furniture_workbench");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new FurnitureWorkbenchRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new KitchenFurnaceRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MicrowaveRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new GrillRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WaterCoolerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List recipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)FurnitureWorkbenchRecipe.Type.INSTANCE);
        List furnaceRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)KitchenFurnaceRecipe.Type.INSTANCE);
        List microwaveRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)MicrowaveRecipe.Type.INSTANCE);
        List grillRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)GrillRecipe.Type.INSTANCE);
        List waterCoolerRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)WaterCoolerRecipe.Type.INSTANCE);
        registration.addRecipes(FurnitureWorkbenchRecipeCategory.FURNITURE_WORKBENCH_RECIPE_TYPE, recipes);
        registration.addRecipes(KitchenFurnaceRecipeCategory.KITCHEN_FURNACE_RECIPE_TYPE, furnaceRecipes);
        registration.addRecipes(MicrowaveRecipeCategory.MICROWAVE_RECIPE_TYPE, microwaveRecipes);
        registration.addRecipes(GrillRecipeCategory.GRILL_RECIPE_TYPE, grillRecipes);
        registration.addRecipes(WaterCoolerRecipeCategory.WATER_COOLER_RECIPE_TYPE, waterCoolerRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        registration.addRecipeClickArea(FurnitureWorkbenchScreen.class, 120, 30, 20, 30, new RecipeType[]{FurnitureWorkbenchRecipeCategory.FURNITURE_WORKBENCH_RECIPE_TYPE});
        registration.addRecipeClickArea(KitchenFurnaceScreen.class, 70, 30, 20, 30, new RecipeType[]{KitchenFurnaceRecipeCategory.KITCHEN_FURNACE_RECIPE_TYPE});
        registration.addRecipeClickArea(MicrowaveScreen.class, 70, 30, 20, 30, new RecipeType[]{MicrowaveRecipeCategory.MICROWAVE_RECIPE_TYPE});
        registration.addRecipeClickArea(GrillScreen.class, 70, 30, 20, 30, new RecipeType[]{GrillRecipeCategory.GRILL_RECIPE_TYPE});
        registration.addRecipeClickArea(WaterCoolerScreen.class, 70, 30, 20, 30, new RecipeType[]{WaterCoolerRecipeCategory.WATER_COOLER_RECIPE_TYPE});
    }

    private boolean isJEILoaded() {
        return ModList.get().isLoaded("jei");
    }
}

