/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.screen;

import com.yablon.furnitury.block.ModBlocks;
import com.yablon.furnitury.block.entity.KitchenFurnaceBlockEntity;
import com.yablon.furnitury.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;

public class KitchenFurnaceMenu
extends AbstractContainerMenu {
    public final KitchenFurnaceBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 6;

    public KitchenFurnaceMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(6));
    }

    public KitchenFurnaceMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.KITCHEN_FURNACE_MENU.get(), pContainerId);
        this.blockEntity = (KitchenFurnaceBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 49, 11));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 80, 11));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 111, 11));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 49, 59));
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 80, 59));
            this.m_38897_((Slot)new SlotItemHandler(handler, 5, 111, 59));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress(int index) {
        int current = this.data.m_6413_(index);
        int max = this.data.m_6413_(3);
        int arrowSize = 26;
        return max != 0 && current != 0 ? current * arrowSize / max : 0;
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 42, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 42) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return KitchenFurnaceMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.KITCHEN_FURNACE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

