/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.client.recipebook;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.EnumSet;

public enum CaskRecipeBookTab {
    MEALS("meals"),
    DRINKS("drinks"),
    MISC("misc");

    public static final Codec<CaskRecipeBookTab> CODEC;
    public final String name;

    private CaskRecipeBookTab(String name) {
        this.name = name;
    }

    public static CaskRecipeBookTab findByName(String name) {
        for (CaskRecipeBookTab value : CaskRecipeBookTab.values()) {
            if (!value.name.equals(name)) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    static {
        CODEC = Codec.STRING.flatXmap(s -> {
            CaskRecipeBookTab tab = CaskRecipeBookTab.findByName(s);
            if (tab == null) {
                return DataResult.error(() -> "Optional field 'recipe_book_tab' does not match any valid tab. If defined, must be one of the following: " + String.valueOf(EnumSet.allOf(CaskRecipeBookTab.class)));
            }
            return DataResult.success((Object)((Object)tab));
        }, tab -> DataResult.success((Object)tab.toString()));
    }
}

