/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.integration.jei;

import alabaster.hearthandharvest.client.gui.CaskGUI;
import alabaster.hearthandharvest.common.block.entity.container.CaskMenu;
import alabaster.hearthandharvest.common.registry.HHModItems;
import alabaster.hearthandharvest.common.registry.HHModMenuTypes;
import alabaster.hearthandharvest.common.utilities.HHTextUtils;
import alabaster.hearthandharvest.integration.jei.HHRecipeTypes;
import alabaster.hearthandharvest.integration.jei.HHRecipes;
import alabaster.hearthandharvest.integration.jei.category.AgingRecipeCategory;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("hearthandharvest", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new AgingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        HHRecipes modRecipes = new HHRecipes();
        registration.addRecipes(HHRecipeTypes.AGING, modRecipes.getCaskRecipes());
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)HHModItems.WATERING_CAN.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{HHTextUtils.getTranslation("jei.info.watering_can", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)HHModItems.TREE_TAPPER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{HHTextUtils.getTranslation("jei.info.tree_tapper", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)HHModItems.SAP_BUCKET.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{HHTextUtils.getTranslation("jei.info.sap_bucket", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)Items.f_42402_), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{HHTextUtils.getTranslation("jei.info.pluck_chickens", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)HHModItems.WILD_RED_GRAPES.get()), new ItemStack((ItemLike)HHModItems.RED_GRAPES.get()), new ItemStack((ItemLike)HHModItems.WILD_GREEN_GRAPES.get()), new ItemStack((ItemLike)HHModItems.GREEN_GRAPES.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{HHTextUtils.getTranslation("jei.info.wild_grapes", new Object[0])});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)HHModItems.CASK.get()), new RecipeType[]{HHRecipeTypes.AGING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CaskGUI.class, 89, 25, 24, 17, new RecipeType[]{HHRecipeTypes.AGING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CaskMenu.class, (MenuType)HHModMenuTypes.CASK.get(), HHRecipeTypes.AGING, 0, 6, 9, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

