/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.integration.jei.category;

import alabaster.hearthandharvest.common.crafting.CaskRecipe;
import alabaster.hearthandharvest.common.registry.HHModItems;
import alabaster.hearthandharvest.common.utilities.HHTextUtils;
import alabaster.hearthandharvest.integration.jei.HHRecipeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;
import vectorwing.farmersdelight.common.utility.RecipeUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AgingRecipeCategory
implements IRecipeCategory<CaskRecipe> {
    protected final IDrawable timeIcon;
    protected final IDrawable expIcon;
    protected final IDrawableAnimated arrow;
    private final Component title = HHTextUtils.getTranslation("jei.aging", new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;

    public AgingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("hearthandharvest", "textures/gui/jei/jei_cask_gui.png");
        this.background = helper.createDrawable(backgroundImage, 33, 16, 116, 42);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)HHModItems.CASK.get()));
        this.timeIcon = helper.createDrawable(backgroundImage, 176, 32, 8, 11);
        this.expIcon = helper.createDrawable(backgroundImage, 176, 43, 9, 9);
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 15, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<CaskRecipe> getRecipeType() {
        return HHRecipeTypes.AGING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CaskRecipe recipe, IFocusGroup focusGroup) {
        NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
        ItemStack resultStack = RecipeUtils.getResultItem((Recipe)recipe);
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                if (inputIndex >= recipeIngredients.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, column * borderSlotSize + 6, row * borderSlotSize + 4).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(inputIndex)).m_43908_()));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 12).addItemStack(resultStack);
    }

    public void draw(CaskRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 51, 12);
        this.timeIcon.draw(guiGraphics, 54, 5);
        if (recipe.getExperience() > 0.0f) {
            this.expIcon.draw(guiGraphics, 53, 24);
        }
    }

    public List<Component> getTooltipStrings(CaskRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (ClientRenderUtils.isCursorInsideBounds((int)47, (int)4, (int)22, (int)28, (double)mouseX, (double)mouseY)) {
            float experience;
            ArrayList<Component> tooltipStrings = new ArrayList<Component>();
            int cookTime = recipe.getCookTime();
            if (cookTime > 0) {
                int cookTimeSeconds = cookTime / 20;
                tooltipStrings.add((Component)Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds}));
            }
            if ((experience = recipe.getExperience()) > 0.0f) {
                tooltipStrings.add((Component)Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)}));
            }
            return tooltipStrings;
        }
        return Collections.emptyList();
    }
}

