/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.conczin.immersive_furniture.client.gui.FakeCamera;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;

public class PreviewParticleEngine {
    private static final List<ParticleRenderType> RENDER_ORDER = ImmutableList.of((Object)ParticleRenderType.f_107429_, (Object)ParticleRenderType.f_107430_, (Object)ParticleRenderType.f_107432_, (Object)ParticleRenderType.f_107431_, (Object)ParticleRenderType.f_107433_);
    private final Map<ParticleRenderType, Queue<Particle>> particles = Maps.newIdentityHashMap();

    public void add(Particle particle) {
        this.particles.computeIfAbsent(particle.m_7556_(), particleRenderType -> EvictingQueue.create((int)16384)).add(particle);
    }

    public void addParticle(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle particle = Minecraft.m_91087_().f_91061_.m_107370_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.add(particle);
        }
    }

    public void tick() {
        this.particles.forEach((particleRenderType, queue) -> this.tickParticleList((Collection<Particle>)queue));
    }

    private void tickParticleList(Collection<Particle> particles) {
        if (!particles.isEmpty()) {
            Iterator<Particle> iterator = particles.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                particle.m_5989_();
                if (particle.m_107276_()) continue;
                iterator.remove();
            }
        }
    }

    public void render(PoseStack poseStack, LightTexture lightTexture, Camera camera, float partialTicks) {
        lightTexture.m_109896_();
        RenderSystem.enableDepthTest();
        PoseStack viewStack = RenderSystem.getModelViewStack();
        viewStack.m_85836_();
        viewStack.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        for (ParticleRenderType particleRenderType : RENDER_ORDER) {
            Iterable iterable = this.particles.get(particleRenderType);
            if (iterable == null) continue;
            RenderSystem.setShader(GameRenderer::m_172829_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            particleRenderType.m_6505_(bufferBuilder, textureManager);
            for (Particle particle : iterable) {
                particle.m_5744_((VertexConsumer)bufferBuilder, camera, partialTicks);
            }
            particleRenderType.m_6294_(tesselator);
        }
        viewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        lightTexture.m_109891_();
    }

    public void renderParticles(GuiGraphics graphics, float yaw, float pitch, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            return;
        }
        FakeCamera camera = new FakeCamera();
        camera.setup((BlockGetter)minecraft.f_91073_, (Entity)minecraft.f_91074_, false, false, partialTicks, yaw, pitch);
        this.render(graphics.m_280168_(), minecraft.f_91063_.m_109154_(), camera, partialTicks);
    }
}

