/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery;

import immersive_aircraft.client.gui.SlotRenderer;
import immersive_aircraft.client.gui.VehicleScreen;
import immersive_aircraft.client.gui.VehicleScreenRegistry;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.screen.VehicleScreenHandler;
import immersive_machinery.Common;
import immersive_machinery.client.gui.MachinerySlotRenderer;
import immersive_machinery.client.gui.screen.BambooBeeScreen;
import immersive_machinery.client.gui.screen.CopperfinScreen;
import immersive_machinery.client.gui.screen.TunnelDiggerScreen;
import immersive_machinery.entity.BambooBee;
import immersive_machinery.entity.Copperfin;
import immersive_machinery.entity.TunnelDigger;
import immersive_machinery.network.ClientNetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;

public class Client {
    public static void init() {
        Common.networkManager = new ClientNetworkManager(Minecraft.m_91087_());
    }

    private static <T extends VehicleEntity, S extends VehicleScreen> void registerVehicleScreen(Class<T> vehicleClass, TriFunction<T, VehicleScreenHandler, LocalPlayer, S> screenFactory) {
        VehicleScreenRegistry.register(vehicleClass, (vehicle, player, message) -> {
            Minecraft client = Minecraft.m_91087_();
            if (client.f_91073_ != null && client.f_91074_ != null && vehicleClass.isInstance(vehicle)) {
                VehicleEntity castedVehicle = (VehicleEntity)vehicleClass.cast(vehicle);
                VehicleScreenHandler handler = (VehicleScreenHandler)vehicle.m_7208_(message.getSyncId(), client.f_91074_.m_150109_(), (Player)client.f_91074_);
                assert (handler != null);
                VehicleScreen screen = (VehicleScreen)screenFactory.apply(castedVehicle, handler, client.f_91074_);
                client.f_91074_.f_36096_ = screen.m_6262_();
                client.m_91152_((Screen)screen);
            }
        });
    }

    static {
        Client.registerVehicleScreen(BambooBee.class, (vehicle, handler, player) -> new BambooBeeScreen((BambooBee)((Object)vehicle), (VehicleScreenHandler)handler, player.m_150109_(), vehicle.m_5446_()));
        Client.registerVehicleScreen(TunnelDigger.class, (vehicle, handler, player) -> new TunnelDiggerScreen((TunnelDigger)((Object)vehicle), (VehicleScreenHandler)handler, player.m_150109_(), vehicle.m_5446_()));
        Client.registerVehicleScreen(Copperfin.class, (vehicle, handler, player) -> new CopperfinScreen((Copperfin)((Object)vehicle), (VehicleScreenHandler)handler, player.m_150109_(), vehicle.m_5446_()));
        SlotRenderer.register((String)Common.SLOT_SHARDS, (SlotRenderer.Renderer)new MachinerySlotRenderer(0, 22, false));
        SlotRenderer.register((String)Common.SLOT_FILTER, (SlotRenderer.Renderer)new MachinerySlotRenderer(110, 18, true));
    }

    @FunctionalInterface
    static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

