/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.util;

import immersive_paintings.resources.ByteImage;

public class ImageManipulations {
    public static int scanForPixelArtMultiple(ByteImage image) {
        int[] hist = new int[64];
        for (int y = 0; y < image.getHeight(); y += 7) {
            int l = 0;
            int lastColor = 0;
            for (int x = 0; x < image.getWidth(); ++x) {
                int color = image.getARGB(x, y);
                if (x == 0 || lastColor == color) {
                    ++l;
                } else {
                    if (l < hist.length) {
                        int n = l;
                        hist[n] = hist[n] + 1;
                    }
                    l = 1;
                }
                lastColor = color;
            }
        }
        int bestScore = 0;
        int best = 1;
        for (int i = 1; i < hist.length; ++i) {
            if (hist[i] <= bestScore) continue;
            bestScore = hist[i];
            best = i;
        }
        return best;
    }

    public static void resize(ByteImage image, ByteImage source, double zoom, int ox, int oy) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int red = 0;
                int green = 0;
                int blue = 0;
                int alpha = 0;
                int samples = 0;
                int px = Math.max(0, (int)((double)ox + zoom * (double)x));
                while ((double)px < Math.min((double)source.getWidth(), (double)ox + zoom * (double)(x + 1))) {
                    int py = Math.max(0, (int)((double)oy + zoom * (double)y));
                    while ((double)py < Math.min((double)source.getHeight(), (double)oy + zoom * (double)(y + 1))) {
                        int index = source.getIndex(px, py);
                        byte[] bytes = source.getBytes();
                        red += bytes[index] & 0xFF;
                        green += bytes[index + 1] & 0xFF;
                        blue += bytes[index + 2] & 0xFF;
                        alpha += bytes[index + 3] & 0xFF;
                        ++samples;
                        ++py;
                    }
                    ++px;
                }
                if (samples > 0) {
                    red /= samples;
                    green /= samples;
                    blue /= samples;
                    alpha /= samples;
                }
                image.setPixel(x, y, red, green, blue, alpha);
            }
        }
    }

    public static void dither(ByteImage image, double dither) {
        float[] hsv = new float[3];
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                image.getHSV(hsv, x, y);
                for (int i = 1; i < 3; ++i) {
                    hsv[i] = x % 2 == y % 2 ? (float)Math.min(1.0, (double)hsv[i] + dither * 0.5) : (float)Math.max(0.0, (double)hsv[i] - dither * 0.5);
                }
                image.setHSV(x, y, hsv);
            }
        }
    }

    public static void reduceColors(ByteImage image, int bins) {
        float[] hsv = new float[3];
        float[][] hist = new float[3][256];
        boolean EXCLUDE_HUE = true;
        int base = image.getWidth() * image.getHeight();
        for (int channel = 1; channel < 3; ++channel) {
            for (int x = 0; x < 256; ++x) {
                hist[channel][x] = (float)base / 255.0f;
            }
        }
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                image.getHSV(hsv, x, y);
                for (int i = 0; i < 3; ++i) {
                    float[] fArray = hist[i];
                    int n = ImageManipulations.toByte(hsv[i]);
                    fArray[n] = fArray[n] + 1.0f;
                }
            }
        }
        int binSize = (image.getWidth() * image.getHeight() + base) / bins;
        float[][] lookup = new float[3][256];
        for (int channel = 1; channel < 3; ++channel) {
            int start = 0;
            for (int bin = 0; bin < bins; ++bin) {
                int end;
                int sum = 0;
                int pixels = 0;
                for (end = start; pixels <= binSize && end < 256; ++end) {
                    float v = hist[channel][end];
                    pixels = (int)((float)pixels + v);
                    sum = (int)((float)sum + (float)end * v);
                }
                for (int b = start; b < end; ++b) {
                    lookup[channel][b] = (float)sum / (float)pixels / 255.0f;
                }
                start = end;
            }
        }
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                image.getHSV(hsv, x, y);
                for (int channel = 1; channel < 3; ++channel) {
                    hsv[channel] = lookup[channel][ImageManipulations.toByte(hsv[channel])];
                }
                image.setHSV(x, y, hsv);
            }
        }
    }

    private static int toByte(float v) {
        return Math.min(255, Math.max(0, (int)(v * 255.0f)));
    }
}

