/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import dev.lucaargolo.mekanismcovers.MekanismCovers;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CoverRecipe
extends CustomRecipe {
    private static final Ingredient COVER_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MekanismCovers.COVER.get(), (ItemLike)MekanismCovers.EMPTY_COVER.get()});

    public CoverRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pInv, @NotNull Level pLevel) {
        int coverQnt = 0;
        boolean coverFull = false;
        int blockQnt = 0;
        for (int slot = 0; slot < pInv.m_6643_(); ++slot) {
            BlockItem blockItem;
            ItemStack stack = pInv.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (COVER_INGREDIENT.test(stack)) {
                ++coverQnt;
                coverFull = coverFull || stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("CoverBlockItem");
                continue;
            }
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && !((blockItem = (BlockItem)item).m_40614_() instanceof EntityBlock)) {
                BlockState state;
                Block block = blockItem.m_40614_();
                if (block.m_180643_(state = block.m_49966_(), (BlockGetter)pLevel, BlockPos.f_121853_)) {
                    ++blockQnt;
                    continue;
                }
                return false;
            }
            return false;
        }
        return coverQnt == 1 && (!coverFull && blockQnt == 1 || coverFull && blockQnt == 0);
    }

    @NotNull
    public ItemStack assemble(CraftingContainer pInv, @NotNull RegistryAccess pRegistryAccess) {
        Block block = Blocks.f_50016_;
        boolean isCleanOperation = false;
        for (int slot = 0; slot < pInv.m_6643_(); ++slot) {
            BlockItem blockItem;
            ItemStack stack = pInv.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (COVER_INGREDIENT.test(stack)) {
                isCleanOperation = isCleanOperation || stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("CoverBlockItem");
                continue;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem) || (blockItem = (BlockItem)item).m_40614_() instanceof EntityBlock) continue;
            block = blockItem.m_40614_();
        }
        if (isCleanOperation) {
            return new ItemStack((ItemLike)MekanismCovers.EMPTY_COVER.get());
        }
        if (block != Blocks.f_50016_) {
            ItemStack result = new ItemStack((ItemLike)MekanismCovers.COVER.get());
            result.m_41784_().m_128365_("CoverBlockItem", (Tag)block.m_5456_().m_7968_().m_41739_(new CompoundTag()));
            return result;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer pContainer) {
        NonNullList list = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = pContainer.m_8020_(i);
            if (!stack.m_41782_() || !Objects.requireNonNull(stack.m_41783_()).m_128441_("CoverBlockItem")) continue;
            ItemStack remaining = ItemStack.m_41712_((CompoundTag)Objects.requireNonNull(stack.m_41783_()).m_128469_("CoverBlockItem"));
            list.set(i, (Object)remaining);
        }
        return list;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return new ItemStack((ItemLike)MekanismCovers.COVER.get());
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MekanismCovers.COVER_SERIALIZER.get();
    }
}

