/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBurnerBlock
extends BaseEntityBlock
implements IWrenchable {
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> HEAT_LEVEL = EnumProperty.m_61587_((String)"blaze", BlazeBurnerBlock.HeatLevel.class);

    protected BaseBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEAT_LEVEL});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos.m_7494_())) instanceof BasinBlockEntity) {
            BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
            basin.notifyChangeOfContents();
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        float damage = 0.0f;
        boolean giveFire = false;
        int time = 0;
        switch ((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)) {
            case SMOULDERING: {
                damage = 0.5f;
                break;
            }
            case FADING: {
                damage = 1.0f;
                giveFire = true;
                time = 6;
                break;
            }
            case KINDLED: {
                damage = 2.0f;
                giveFire = true;
                time = 8;
                break;
            }
            case SEETHING: {
                damage = 4.0f;
                giveFire = true;
                time = 300;
            }
        }
        if (!entity.m_20161_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(level.m_269111_().m_269047_(), damage);
        }
        if (giveFire && !entity.m_5825_()) {
            entity.m_20254_(time);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public BlockState getState(BlazeBurnerBlock.HeatLevel level) {
        return (BlockState)this.m_49966_().m_61124_(HEAT_LEVEL, (Comparable)level);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return null;
    }
}

