/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block.entity;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.lang.LangNumberFormat;
import net.dragonegg.moreburners.config.CommonConfig;
import net.dragonegg.moreburners.content.block.ElectricBurnerBlock;
import net.dragonegg.moreburners.content.block.entity.BaseBurnerBlockEntity;
import net.dragonegg.moreburners.registry.BlockRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ElectricBurnerBlockEntity
extends BaseBurnerBlockEntity {
    public static final int MAX_ENERGY_CAP = (Integer)CommonConfig.ELECTRIC_BURNER_MAX_CAPACITY.get();
    public static final int ENERGY_COST = (Integer)CommonConfig.ELECTRIC_BURNER_ENERGY_COST.get();
    public static final double ENERGY_MULTIPLIER_1 = (Double)CommonConfig.ELECTRIC_BURNER_ENERGY_MULTIPLIER_1.get();
    public static final double ENERGY_MULTIPLIER_2 = (Double)CommonConfig.ELECTRIC_BURNER_ENERGY_MULTIPLIER_2.get();
    public static final double MAX_HEAT = (Double)CommonConfig.ELECTRIC_BURNER_MAX_HEAT.get();
    public static final double UPGRADED_MAX_HEAT = (Double)CommonConfig.ELECTRIC_BURNER_UPGRADED_MAX_HEAT.get();
    public static final double HEATING_RATE = (Double)CommonConfig.ELECTRIC_BURNER_HEATING_RATE.get();
    public static final double COOLING_RATE = (Double)CommonConfig.ELECTRIC_BURNER_COOLING_RATE.get();
    public EnergyStorage energy = new EnergyStorage(MAX_ENERGY_CAP);
    public double energy_cost;
    public boolean upgraded;
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public ElectricBurnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.ELECTRIC_BURNER_ENTITY.get(), pos, state);
        this.max_heat = MAX_HEAT;
        this.energy_cost = ENERGY_COST;
        this.upgraded = false;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energy.deserializeNBT((Tag)IntTag.m_128679_((int)nbt.m_128451_("energy")));
        this.upgraded = nbt.m_128471_("upgraded");
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("energy", this.energy.getEnergyStored());
        nbt.m_128379_("upgraded", this.upgraded);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("energy", this.energy.getEnergyStored());
        nbt.m_128379_("upgraded", this.upgraded);
        return nbt;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        return !this.f_58859_ && cap == ForgeCapabilities.ENERGY ? this.energyCap.cast() : super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCap.invalidate();
    }

    public void setUpgrade(boolean upgraded) {
        this.upgraded = upgraded;
        this.updateBlockState();
    }

    @Override
    public void updateBlockState() {
        super.updateBlockState();
        this.setBlockUpgraded(this.upgraded);
    }

    public void setBlockUpgraded(boolean upgraded) {
        boolean state = this.getUpgradedFromBlock();
        if (state != upgraded) {
            assert (this.f_58857_ != null);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ElectricBurnerBlock.UPGRADED, (Comparable)Boolean.valueOf(upgraded)));
            this.m_6596_();
        }
    }

    public boolean getUpgradedFromBlock() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)ElectricBurnerBlock.UPGRADED) ? (Boolean)state.m_61143_((Property)ElectricBurnerBlock.UPGRADED) : false;
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        ++this.ticksExisted;
        this.max_heat = this.upgraded ? UPGRADED_MAX_HEAT : MAX_HEAT;
        super.tick(level, pos, state);
        double d = ENERGY_COST;
        this.energy_cost = d * (switch (this.getHeatLevelFromBlock()) {
            default -> throw new IncompatibleClassChangeError();
            case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> 1.0;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> ENERGY_MULTIPLIER_1;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> ENERGY_MULTIPLIER_2;
        });
        if (!level.m_5776_()) {
            double prevHeat = this.heat;
            if (this.energy.getEnergyStored() > (int)this.energy_cost) {
                this.energy.extractEnergy((int)this.energy_cost, false);
            } else {
                this.canWork = false;
            }
            if (this.ticksExisted % 20 == 0) {
                this.heat = this.canWork ? (this.heat += HEATING_RATE) : (this.heat -= COOLING_RATE);
                this.canWork = true;
            }
            this.heat = Mth.m_14008_((double)this.heat, (double)0.0, (double)this.max_heat);
            if (this.heat != prevHeat) {
                this.m_6596_();
                this.updateBlockState();
            }
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getUpgradedFromBlock()) {
            this.forGoggles(tooltip, Lang.builder((String)"moreburners").translate("burner.status.upgraded", new Object[0]).style(ChatFormatting.BLUE), 1);
        }
        tooltip.add((Component)Component.m_237119_());
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").translate("burner.energy.title", new Object[0]).style(ChatFormatting.GRAY), 0);
        LangBuilder builder = Lang.builder((String)"moreburners").text(LangNumberFormat.format((double)((int)this.energy_cost))).translate("burner.energy.unit", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.builder((String)"moreburners").translate("burner.per_tick", new Object[0]).style(ChatFormatting.DARK_GRAY));
        this.forGoggles(tooltip, builder, 1);
        return added;
    }
}

