/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.weapon.AmmoConfig;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Optional;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class AmmoData
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    @Optional
    private AmmoConfig ammo = new AmmoConfig();
    @Optional
    private ProjectileConfig projectile = new ProjectileConfig();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("ammo", (Tag)this.ammo.serializeNBT());
        tag.m_128365_("projectile", (Tag)this.projectile.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("ammo", 10)) {
            this.ammo = AmmoConfig.create(tag.m_128469_("ammo"));
        }
        if (tag.m_128425_("projectile", 10)) {
            this.projectile = ProjectileConfig.create(tag.m_128469_("projectile"));
        }
    }

    public AmmoData copy() {
        AmmoData config = new AmmoData();
        config.ammo = this.ammo;
        config.projectile = this.projectile;
        return config;
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.add("ammo", (JsonElement)this.ammo.toJsonObject());
        object.add("projectile", (JsonElement)this.projectile.toJsonObject());
        return object;
    }

    public AmmoConfig getAmmo() {
        return this.ammo;
    }

    public ProjectileConfig getProjectile() {
        return this.projectile;
    }

    public static AmmoData create(CompoundTag tag) {
        AmmoData ammo = new AmmoData();
        ammo.deserializeNBT(tag);
        return ammo;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Fuel");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final AmmoData ammo;

        private Builder() {
            this.ammo = new AmmoData();
        }

        private Builder(AmmoData ammo) {
            this.ammo = ammo.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(AmmoData ammo) {
            return new Builder(ammo);
        }

        public AmmoData build() {
            return this.ammo.copy();
        }
    }
}

