/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.nukateam.ntgl.client.handlers.ClientPlayHandler;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.network.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.network.NetworkEvent;

public class S2CMessagePlayerAnimation
implements IMessage<S2CMessagePlayerAnimation> {
    int entityId;
    AnimationType animation;
    InteractionHand hand;

    public S2CMessagePlayerAnimation() {
    }

    public S2CMessagePlayerAnimation(int entityId, AnimationType animation, InteractionHand hand) {
        this.entityId = entityId;
        this.animation = animation;
        this.hand = hand;
    }

    @Override
    public void encode(S2CMessagePlayerAnimation message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.m_130070_(message.animation.toString());
        buf.m_130068_((Enum)message.hand);
    }

    @Override
    public S2CMessagePlayerAnimation decode(FriendlyByteBuf buf) {
        return new S2CMessagePlayerAnimation(buf.readInt(), AnimationType.getType(buf.m_130277_()), (InteractionHand)buf.m_130066_(InteractionHand.class));
    }

    @Override
    public void handle(S2CMessagePlayerAnimation message, NetworkEvent.Context supplier) {
        supplier.enqueueWork(() -> ClientPlayHandler.handleMessageAnimation(message));
        supplier.setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public AnimationType getAnimation() {
        return this.animation;
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

