/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class FuelUtils {
    public static final String FUEL = "Fuel";

    public static CompoundTag getOrCreateFuelTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(FUEL, 10)) {
            return tag.m_128469_(FUEL);
        }
        return new CompoundTag();
    }

    public static boolean hasFuel(WeaponData data) {
        return FuelUtils.hasFuel(data, true);
    }

    public static boolean hasFuel(WeaponData data, boolean requareAll) {
        Set<AmmoHolder> allFuel = WeaponModifierHelper.getAllFuel(data);
        for (AmmoHolder fuelType : allFuel) {
            boolean isMandatory = WeaponModifierHelper.isFuelMandatory(fuelType.getId(), data);
            if (!isMandatory && !requareAll || FuelUtils.hasFuel(fuelType.getId(), data)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasFuel(ResourceLocation id, WeaponData data) {
        int amount = WeaponModifierHelper.getFuelAmountPerUse(id, data);
        int fuel = FuelUtils.getFuel(data.weapon, AmmoHolder.getType(id));
        return fuel >= amount;
    }

    public static boolean isFull(WeaponData data, AmmoHolder ammoHolder) {
        Integer max;
        int fuel = FuelUtils.getFuel(data.weapon, ammoHolder);
        return fuel >= (max = WeaponModifierHelper.getMaxFuel(ammoHolder.getId(), data));
    }

    public static int getFuel(ItemStack stack, AmmoHolder ammoHolder) {
        CompoundTag fuelTag = FuelUtils.getOrCreateFuelTag(stack);
        if (fuelTag.m_128425_(ammoHolder.toString(), 3)) {
            return fuelTag.m_128451_(ammoHolder.toString());
        }
        return 0;
    }

    public static void setFuel(ItemStack stack, AmmoHolder ammoHolder, int value) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag fuelTag = FuelUtils.getOrCreateFuelTag(stack);
        fuelTag.m_128405_(ammoHolder.toString(), value);
        tag.m_128365_(FUEL, (Tag)fuelTag);
        stack.m_41751_(tag);
    }

    public static void addFuel(WeaponData data, AmmoHolder ammoHolder, int value) {
        int oldValue = FuelUtils.getFuel(data.weapon, ammoHolder);
        Integer max = WeaponModifierHelper.getMaxFuel(ammoHolder.getId(), data);
        FuelUtils.setFuel(data.weapon, ammoHolder, Mth.m_14045_((int)(oldValue + value), (int)0, (int)max));
    }

    public static void consumeFuel(AmmoHolder ammoHolder, WeaponData data) {
        int oldValue = FuelUtils.getFuel(data.weapon, ammoHolder);
        Integer max = WeaponModifierHelper.getMaxFuel(ammoHolder.getId(), data);
        int value = WeaponModifierHelper.getFuelAmountPerUse(ammoHolder.getId(), data);
        FuelUtils.setFuel(data.weapon, ammoHolder, Mth.m_14045_((int)(oldValue - value), (int)0, (int)max));
    }

    public static float getFuelPercent(ItemStack stack, AmmoHolder ammoHolder, WeaponData data) {
        int fuel = FuelUtils.getFuel(stack, ammoHolder);
        Integer maxFuel = WeaponModifierHelper.getMaxFuel(ammoHolder.getId(), data);
        float fuelPercent = (float)fuel / (float)maxFuel.intValue();
        return fuelPercent;
    }
}

