/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.mixin.chassis.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nukateam.chassis_core.Global;
import com.nukateam.chassis_core.client.render.utils.GuiUtils;
import com.nukateam.chassis_core.common.data.constants.Resources;
import com.nukateam.chassis_core.common.data.enums.ActionType;
import com.nukateam.chassis_core.common.network.PacketSender;
import com.nukateam.chassis_core.common.util.helpers.PlayerUtils;
import java.awt.Rectangle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryScreenMixin
extends EffectRenderingInventoryScreen<InventoryMenu> {
    public CreativeInventoryScreenMixin(InventoryMenu screenHandler, Inventory playerInventory, Component textComponent) {
        super((AbstractContainerMenu)screenHandler, playerInventory, textComponent);
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="HEAD")})
    public void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> ci) {
        if (!PlayerUtils.isLocalWearingChassis()) {
            return;
        }
        Rectangle rect = new Rectangle(this.getRight() - 51, this.getBottom(), 25, 27);
        if (rect.contains(mouseX, mouseY)) {
            Global.saveMousePos();
            PacketSender.doServerAction(ActionType.OPEN_GUI);
        }
    }

    @Inject(method={"renderBg(Lnet/minecraft/client/gui/GuiGraphics;FII)V"}, at={@At(value="TAIL")})
    public void drawBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY, CallbackInfo ci) {
        PoseStack poseStack = graphics.m_280168_();
        if (!PlayerUtils.isLocalWearingChassis()) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Resources.PLAYER_INVENTORY_BOTTOM_TABS);
        graphics.m_280218_(Resources.PLAYER_INVENTORY_BOTTOM_TABS, this.getRight() - 57, this.getBottom() - 4, 0, 0, 57, 32);
        GuiUtils.drawChassisIcon(graphics, this.getRight() - 30 - 16, this.getBottom() + 4);
    }

    @Unique
    private int getRight() {
        return this.f_97735_ + this.f_97726_;
    }

    @Unique
    private int getBottom() {
        return this.f_97736_ + this.f_97727_;
    }
}

