/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.datapack.handlers;

import com.nukateam.chassis_core.common.network.packet.S2CMessageUpdateChassisConfig;
import com.nukateam.chassis_core.common.network.packet.S2CMessageUpdateEquipmentConfig;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAmmo;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAttachments;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateWeapons;
import com.nukateam.ntgl.modules.datapack.managers.NetworkAmmoManager;
import com.nukateam.ntgl.modules.datapack.managers.NetworkAttachmentManager;
import com.nukateam.ntgl.modules.datapack.managers.NetworkChassisManager;
import com.nukateam.ntgl.modules.datapack.managers.NetworkEquipmentManager;
import com.nukateam.ntgl.modules.datapack.managers.NetworkWeaponManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class NetworkManagerHandler {
    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        NetworkWeaponManager.onServerStopped();
        NetworkAmmoManager.onServerStopped();
        NetworkAttachmentManager.onServerStopped();
        NetworkChassisManager.stop();
        NetworkEquipmentManager.stop();
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkWeaponManager.register(event);
        NetworkAmmoManager.register(event);
        NetworkAttachmentManager.register(event);
        NetworkChassisManager.register(event);
        NetworkEquipmentManager.register(event);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketHandler.getPlayChannel().sendToPlayer(() -> player2, new S2CMessageUpdateWeapons());
            PacketHandler.getPlayChannel().sendToPlayer(() -> player2, new S2CMessageUpdateAmmo());
            PacketHandler.getPlayChannel().sendToPlayer(() -> player2, new S2CMessageUpdateAttachments());
            PacketHandler.getPlayChannel().sendToPlayer(() -> player2, new S2CMessageUpdateChassisConfig());
            PacketHandler.getPlayChannel().sendToPlayer(() -> player2, new S2CMessageUpdateEquipmentConfig());
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketHandler.getPlayChannel().sendToAll(new S2CMessageUpdateWeapons());
            PacketHandler.getPlayChannel().sendToAll(new S2CMessageUpdateAmmo());
            PacketHandler.getPlayChannel().sendToAll(new S2CMessageUpdateAttachments());
            PacketHandler.getPlayChannel().sendToAll(new S2CMessageUpdateChassisConfig());
            PacketHandler.getPlayChannel().sendToAll(new S2CMessageUpdateEquipmentConfig());
        }
    }
}

