/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.datapack.managers;

import com.google.common.collect.ImmutableMap;
import com.nukateam.chassis_core.common.config.ChassisConfig;
import com.nukateam.chassis_core.common.foundation.entity.Chassis;
import com.nukateam.chassis_core.common.network.managers.Configs;
import com.nukateam.chassis_core.modules.config.utils.ConfigUtils;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="ntgl")
public class NetworkChassisManager
extends SimplePreparableReloadListener<Map<EntityType<Chassis>, ChassisConfig>> {
    public static final String PATH = "cc/chassis";
    private static NetworkChassisManager instance;
    private Map<ResourceLocation, ChassisConfig> registeredConfig = new HashMap<ResourceLocation, ChassisConfig>();

    @Nullable
    public static NetworkChassisManager get() {
        return instance;
    }

    public static void register(AddReloadListenerEvent event) {
        NetworkChassisManager networkGunManager = new NetworkChassisManager();
        event.addListener((PreparableReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    public static void stop() {
        instance = null;
    }

    protected Map<EntityType<Chassis>, ChassisConfig> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return ConfigUtils.getConfigMap(manager, ForgeRegistries.ENTITY_TYPES, v -> true, ChassisConfig.class, PATH);
    }

    protected void apply(Map<EntityType<Chassis>, ChassisConfig> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((chassis, config) -> {
            Validate.notNull((Object)ForgeRegistries.ENTITY_TYPES.getKey(chassis));
            builder.put((Object)ForgeRegistries.ENTITY_TYPES.getKey(chassis), config);
            Configs.CHASSIS_CONFIGS.put((EntityType<Chassis>)chassis, new ConfigSupplier<ChassisConfig>((ChassisConfig)config));
        });
        this.registeredConfig = builder.build();
    }

    public void writeRegisteredConfig(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredConfig.size());
        this.registeredConfig.forEach((id, config) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(config.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, ChassisConfig> readRegisteredConfigs(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                ChassisConfig config = ChassisConfig.create(buffer.m_130260_());
                builder.put((Object)id, (Object)config);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredConfig(Map<ResourceLocation, ChassisConfig> registeredConfig) {
        if (registeredConfig != null) {
            for (Map.Entry<ResourceLocation, ChassisConfig> entry : registeredConfig.entrySet()) {
                EntityType item = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entry.getKey());
                Configs.CHASSIS_CONFIGS.put((EntityType<Chassis>)item, new ConfigSupplier<ChassisConfig>(entry.getValue()));
            }
            return true;
        }
        return false;
    }
}

