/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.ponder.particle;

import com.petrolpark.mixin.compat.create.accessor.client.PonderLevelAccessor;
import java.util.Random;
import net.createmod.ponder.api.ParticleEmitter;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PetrolparkEmitters {
    private static final Random RANDOM = new Random();

    private static final <T extends ParticleOptions> ParticleEmitter inAABB(T data, AABB aabb, double vx, double vy, double vz) {
        return (w, x, y, z) -> w.m_7106_(data, x + aabb.f_82288_ + (double)RANDOM.nextFloat() * aabb.m_82362_(), z + aabb.f_82289_ + (double)RANDOM.nextFloat() * aabb.m_82376_(), z + aabb.f_82290_ + (double)RANDOM.nextFloat() * aabb.m_82385_(), vx, vy, vz);
    }

    public static final <T extends ParticleOptions> ParticleEmitter inAABB(T data, AABB aabb, Vec3 velocity) {
        return PetrolparkEmitters.inAABB(data, aabb, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
    }

    public static final ParticleEmitter fireworkBall(double speed, int size, int[] colors, int[] fadeColors, boolean trail, boolean twinkle) {
        return (w, x, y, z) -> {
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double vx = (double)j + (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
                        double vy = (double)i + (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
                        double vz = (double)k + (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
                        double v = Math.sqrt(vx * vx + vy * vy + vz * vz) / speed + RANDOM.nextGaussian() * 0.05;
                        PetrolparkEmitters.createFireworkSpark(w, x, y, z, vx / v, vy / v, vz / v, colors, fadeColors, trail, twinkle);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2 - 1;
                    }
                }
            }
        };
    }

    public static void createFireworkSpark(PonderLevel world, double x, double y, double z, double vx, double vy, double vz, int[] colors, int[] fadeColors, boolean trail, boolean twinkle) {
        FireworkParticles.SparkParticle particle = (FireworkParticles.SparkParticle)((PonderLevelAccessor)world).invokeMakeParticle(ParticleTypes.f_123815_, x, y, z, vx, vy, vz);
        particle.m_106727_(trail);
        particle.m_106729_(twinkle);
        particle.m_107657_(colors[RANDOM.nextInt(colors.length)]);
        if (fadeColors.length > 0) {
            particle.m_107659_(fadeColors[RANDOM.nextInt(fadeColors.length)]);
        }
        world.addParticle((Particle)particle);
    }
}

