/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.loot.numberprovider;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.data.loot.PetrolparkGson;
import com.petrolpark.data.loot.PetrolparkLootContextParams;
import com.petrolpark.data.loot.PetrolparkLootNumberProviderTypes;
import com.petrolpark.data.loot.numberprovider.team.TeamNumberProvider;
import com.petrolpark.team.ITeam;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ContextTeamNumberProvider
implements NumberProvider {
    protected final TeamNumberProvider teamNumberProvider;

    public ContextTeamNumberProvider(TeamNumberProvider teamNumberProvider) {
        this.teamNumberProvider = teamNumberProvider;
    }

    public float m_142688_(LootContext context) {
        ITeam team = (ITeam)context.m_165124_(PetrolparkLootContextParams.TEAM);
        if (team != null) {
            return this.teamNumberProvider.getFloat(team, context);
        }
        return 0.0f;
    }

    public LootNumberProviderType m_142587_() {
        return (LootNumberProviderType)PetrolparkLootNumberProviderTypes.CONTEXT_TEAM.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Sets.union(Set.of(PetrolparkLootContextParams.TEAM), (Set)this.teamNumberProvider.m_6231_());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ContextTeamNumberProvider> {
        public void serialize(JsonObject json, ContextTeamNumberProvider value, JsonSerializationContext serializationContext) {
            json.add("value", PetrolparkGson.get().toJsonTree((Object)value.teamNumberProvider));
        }

        public ContextTeamNumberProvider deserialize(JsonObject json, JsonDeserializationContext serializationContext) {
            return new ContextTeamNumberProvider((TeamNumberProvider)PetrolparkGson.get().fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"value"), TeamNumberProvider.class));
        }
    }
}

