/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe.advancedprocessing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.petrolpark.Petrolpark;
import com.petrolpark.RequiresCreate;
import com.petrolpark.recipe.advancedprocessing.IBiomeSpecificProcessingRecipe;
import com.petrolpark.recipe.advancedprocessing.firsttimelucky.IFirstTimeLuckyRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

@RequiresCreate
public class AdvancedProcessingRecipeSerializer<T extends ProcessingRecipe<?>>
extends ProcessingRecipeSerializer<T> {
    public AdvancedProcessingRecipeSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory) {
        super(factory);
    }

    protected void writeToJson(JsonObject json, T recipe) {
        IBiomeSpecificProcessingRecipe biomeRecipe;
        Set<IBiomeSpecificProcessingRecipe.BiomeValue> biomes;
        super.writeToJson(json, recipe);
        if (recipe instanceof IBiomeSpecificProcessingRecipe && !(biomes = (biomeRecipe = (IBiomeSpecificProcessingRecipe)recipe).getAllowedBiomes()).isEmpty()) {
            JsonArray jsonArray = new JsonArray(biomes.size());
            biomes.forEach(biome -> jsonArray.add(biome.serialize()));
            json.add("biomes", (JsonElement)jsonArray);
        }
        if (recipe instanceof IFirstTimeLuckyRecipe) {
            IFirstTimeLuckyRecipe luckyRecipe = (IFirstTimeLuckyRecipe)recipe;
            json.addProperty("lucky_first_time", Boolean.valueOf(luckyRecipe.shouldBeLuckyFirstTime()));
        }
    }

    protected T readFromJson(ResourceLocation recipeId, JsonObject json) {
        ProcessingRecipe recipe = super.readFromJson(recipeId, json);
        if (json.has("biomes") && json.get("biomes").isJsonArray()) {
            if (recipe instanceof IBiomeSpecificProcessingRecipe) {
                IBiomeSpecificProcessingRecipe biomeRecipe = (IBiomeSpecificProcessingRecipe)recipe;
                HashSet<IBiomeSpecificProcessingRecipe.BiomeValue> biomes = new HashSet<IBiomeSpecificProcessingRecipe.BiomeValue>();
                json.get("biomes").getAsJsonArray().forEach(e -> {
                    if (!e.isJsonPrimitive()) {
                        throw new JsonSyntaxException("Biome list must contain only names of biomes");
                    }
                    biomes.add(IBiomeSpecificProcessingRecipe.valueFromString(e.getAsString()));
                });
                biomeRecipe.setAllowedBiomes(biomes);
            } else {
                Petrolpark.LOGGER.warn("Recipe " + recipeId + " specifies a biome filter but that is not supported by this recipe type.");
            }
        }
        if (json.has("lucky_first_time")) {
            if (recipe instanceof IFirstTimeLuckyRecipe) {
                IFirstTimeLuckyRecipe luckyRecipe = (IFirstTimeLuckyRecipe)recipe;
                boolean isLucky = false;
                try {
                    isLucky = json.get("lucky_first_time").getAsBoolean();
                }
                catch (UnsupportedOperationException e2) {
                    throw new JsonSyntaxException("The field 'lucky_first_time' must be a single boolean");
                }
                catch (IllegalStateException e3) {
                    throw new JsonSyntaxException("The field 'lucky_first_time' must be a single boolean");
                }
                finally {
                    luckyRecipe.setLuckyFirstTime(isLucky);
                }
            } else {
                Petrolpark.LOGGER.warn("Recipe " + recipeId + " is marked as first-time-lucky but that is not supported by this recipe type.");
            }
        }
        return (T)recipe;
    }

    protected void writeToBuffer(FriendlyByteBuf buffer, T recipe) {
        super.writeToBuffer(buffer, recipe);
        if (recipe instanceof IBiomeSpecificProcessingRecipe) {
            IBiomeSpecificProcessingRecipe biomeRecipe = (IBiomeSpecificProcessingRecipe)recipe;
            Set<IBiomeSpecificProcessingRecipe.BiomeValue> biomes = biomeRecipe.getAllowedBiomes();
            buffer.m_130130_(biomes.size());
            biomes.forEach(biome -> buffer.m_130070_(biome.serialize()));
        }
        if (recipe instanceof IFirstTimeLuckyRecipe) {
            IFirstTimeLuckyRecipe luckyRecipe = (IFirstTimeLuckyRecipe)recipe;
            buffer.writeBoolean(luckyRecipe.shouldBeLuckyFirstTime());
        }
    }

    protected T readFromBuffer(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ProcessingRecipe recipe = super.readFromBuffer(recipeId, buffer);
        if (recipe instanceof IBiomeSpecificProcessingRecipe) {
            IBiomeSpecificProcessingRecipe biomeRecipe = (IBiomeSpecificProcessingRecipe)recipe;
            int biomeCount = buffer.m_130242_();
            HashSet<IBiomeSpecificProcessingRecipe.BiomeValue> biomes = new HashSet<IBiomeSpecificProcessingRecipe.BiomeValue>(biomeCount);
            for (int i = 0; i < biomeCount; ++i) {
                biomes.add(IBiomeSpecificProcessingRecipe.valueFromString(buffer.m_130277_()));
            }
            biomeRecipe.setAllowedBiomes(biomes);
        }
        if (recipe instanceof IFirstTimeLuckyRecipe) {
            IFirstTimeLuckyRecipe luckyRecipe = (IFirstTimeLuckyRecipe)recipe;
            luckyRecipe.setLuckyFirstTime(buffer.readBoolean());
        }
        return (T)recipe;
    }
}

