/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.TelevisionBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTelevisionChannel;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TelevisionBlockEntity
extends ElectricityModuleBlockEntity
implements ILevelAudio {
    public static final Channel WHITE_NOISE = new Channel(Utils.resource("white_noise"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_WHITE_NOISE.get(), 0);
    public static final Channel BLACK_NOISE = new Channel(Utils.resource("black_noise"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_WHITE_NOISE.get(), 0);
    public static final Channel HEART_SCREENSAVER = new Channel(Utils.resource("heart_screensaver"), () -> null, 10);
    public static final Channel COLOUR_TEST = new Channel(Utils.resource("colour_test"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_COLOUR_TEST.get(), 1);
    public static final Channel HEROBRINE = new Channel(Utils.resource("herobrine"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_COLOUR_TEST.get(), 0);
    public static final Channel DANCE_MUSIC = new Channel(Utils.resource("dance_music"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_DANCE_MUSIC.get(), 10);
    public static final Channel VILLAGER_NEWS = new Channel(Utils.resource("villager_news"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_VILLAGER_NEWS.get(), 10);
    public static final Channel RIP_BLIZZARD = new Channel(Utils.resource("rip_blizzard"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_CHIRP_SONG.get(), 5);
    public static final Channel OCEAN_SUNSET = new Channel(Utils.resource("ocean_sunset"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_OCEAN_SUNSET.get(), 10);
    public static final Channel BLOCK_GAME = new Channel(Utils.resource("block_game"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_BLOCKY_GAME.get(), 10);
    public static final Channel PONG = new Channel(Utils.resource("pong"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_RETRO_SONG.get(), 10);
    public static final Channel SILLY_FACE = new Channel(Utils.resource("silly_face"), () -> null, 10);
    public static final List<Channel> VIEWABLE_CHANNELS = List.of(HEART_SCREENSAVER, COLOUR_TEST, DANCE_MUSIC, VILLAGER_NEWS, RIP_BLIZZARD, OCEAN_SUNSET, BLOCK_GAME, PONG, SILLY_FACE);
    public static final List<Channel> ALL_CHANNELS = (List)Util.m_137469_(new ArrayList(), channels -> {
        channels.add(WHITE_NOISE);
        channels.add(BLACK_NOISE);
        channels.add(HEROBRINE);
        channels.addAll(VIEWABLE_CHANNELS);
    });
    public static final Map<ResourceLocation, Channel> ID_TO_CHANNEL = ALL_CHANNELS.stream().collect(Collectors.toMap(c -> c.id, Function.identity()));
    public static final double MAX_AUDIO_DISTANCE = Mth.m_144944_((int)16);
    protected final Vec3 audioPosition;
    protected Channel currentChannel = OCEAN_SUNSET;
    protected Channel lastChannel;
    protected boolean transitioning;
    protected int timer;
    @Nullable
    protected Channel originalChannel;
    protected boolean lockChannel;

    public TelevisionBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.TELEVISION.get(), pos, state);
    }

    public TelevisionBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.audioPosition = pos.m_252807_();
    }

    public Channel getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public SoundEvent getSound() {
        return this.currentChannel.sound().get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)TelevisionBlock.DIRECTION)) {
            Direction direction = ((Direction)state.m_61143_((Property)TelevisionBlock.DIRECTION)).m_122424_();
            Vec3i normal = direction.m_122436_();
            return this.audioPosition.m_82520_((double)normal.m_123341_() * 0.375, (double)normal.m_123342_(), (double)normal.m_123343_() * 0.375);
        }
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return !this.m_58901_() && this.isNodePowered();
    }

    @Override
    public double getAudioRadiusSqr() {
        return MAX_AUDIO_DISTANCE;
    }

    @Override
    public float getAudioPitch() {
        if (this.currentChannel == HEROBRINE || this.currentChannel == BLACK_NOISE) {
            return 0.25f;
        }
        return 1.0f;
    }

    @Override
    public int getAudioHash() {
        return this.f_58858_.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return other == this;
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)BlockStateProperties.f_61448_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BlockStateProperties.f_61448_)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    public void interact() {
        if (!this.transitioning && this.isNodePowered() && !this.lockChannel) {
            Preconditions.checkState((boolean)(this.f_58857_ instanceof ServerLevel));
            int transitionTime = this.f_58857_.f_46441_.m_216339_(5, 20);
            this.f_58857_.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), transitionTime);
            this.lastChannel = this.currentChannel;
            this.setChannel(WHITE_NOISE);
            this.transitioning = true;
        }
    }

    public void selectRandomChannel() {
        int randomIndex;
        Preconditions.checkState((boolean)(this.f_58857_ instanceof ServerLevel));
        if (this.f_58857_.m_46470_()) {
            this.setChannel(COLOUR_TEST);
            this.transitioning = false;
            return;
        }
        ArrayList<Channel> channels = new ArrayList<Channel>(VIEWABLE_CHANNELS);
        channels.remove(this.lastChannel);
        int totalWeight = channels.stream().mapToInt(Channel::weight).sum();
        int i = this.f_58857_.f_46441_.m_216332_(0, totalWeight);
        for (randomIndex = 0; randomIndex < channels.size() - 1 && (i -= ((Channel)channels.get(randomIndex)).weight()) >= 0; ++randomIndex) {
        }
        this.setChannel((Channel)channels.get(randomIndex));
        this.transitioning = false;
    }

    private void setChannel(Channel channel) {
        Preconditions.checkNotNull((Object)this.f_58857_);
        this.currentChannel = channel;
        this.m_6596_();
        if (!this.f_58857_.m_5776_()) {
            Network.getPlay().sendToTrackingBlockEntity(() -> this, (IMessage)new MessageTelevisionChannel(this.f_58858_, channel.id));
        }
    }

    public void setChannelFromId(ResourceLocation id) {
        Channel channel = ID_TO_CHANNEL.get(id);
        if (channel != null) {
            this.setChannel(channel);
        }
    }

    private void specialTick() {
        Preconditions.checkNotNull((Object)this.f_58857_);
        if (this.isNodePowered()) {
            if (this.f_58857_.m_46470_() && ((Boolean)Config.SERVER.television.looseSignalDuringThunderstorm.get()).booleanValue()) {
                if (this.originalChannel != null) {
                    if (this.currentChannel == COLOUR_TEST) {
                        if (this.timer++ >= 1200) {
                            this.setChannel(HEROBRINE);
                            this.timer = 0;
                        }
                    } else if (this.currentChannel == HEROBRINE && this.timer++ == 100) {
                        this.setChannel(BLACK_NOISE);
                        this.timer = 0;
                        this.lockChannel = true;
                    }
                } else if (!this.transitioning && this.currentChannel != WHITE_NOISE) {
                    this.originalChannel = this.currentChannel;
                    this.setChannel(COLOUR_TEST);
                }
                return;
            }
            if (this.originalChannel != null) {
                this.setChannel(this.originalChannel);
                this.originalChannel = null;
                this.lockChannel = false;
            }
        }
        this.timer = 0;
    }

    @Override
    public void moduleTick(Level level) {
        super.moduleTick(level);
        if (!level.f_46443_) {
            this.specialTick();
        } else {
            AudioManager.get().playLevelAudio(this);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        ResourceLocation id;
        super.m_142466_(tag);
        if (tag.m_128425_("CurrentChannel", 8) && (id = ResourceLocation.m_135820_((String)tag.m_128461_("CurrentChannel"))) != null && !id.equals((Object)TelevisionBlockEntity.WHITE_NOISE.id) && ID_TO_CHANNEL.containsKey(id)) {
            this.currentChannel = ID_TO_CHANNEL.get(id);
        }
        if (tag.m_128425_("OriginalChannel", 8) && (id = ResourceLocation.m_135820_((String)tag.m_128461_("OriginalChannel"))) != null && !id.equals((Object)TelevisionBlockEntity.WHITE_NOISE.id) && ID_TO_CHANNEL.containsKey(id)) {
            this.originalChannel = ID_TO_CHANNEL.get(id);
            if (tag.m_128425_("LockChannel", 1)) {
                this.lockChannel = tag.m_128471_("LockChannel");
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.currentChannel != null && this.currentChannel != WHITE_NOISE) {
            tag.m_128359_("CurrentChannel", this.currentChannel.id.toString());
        }
        if (this.originalChannel != null && this.originalChannel != WHITE_NOISE) {
            tag.m_128359_("OriginalChannel", this.originalChannel.id.toString());
            tag.m_128379_("LockChannel", this.lockChannel);
        }
    }

    public record Channel(ResourceLocation id, Supplier<SoundEvent> sound, int weight) {
    }
}

