/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.goal;

import com.github.mnesikos.simplycats.block.CatnipBlock;
import com.github.mnesikos.simplycats.block.SCBlocks;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.item.SCItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.ForgeEventFactory;

public class CatSeekCatnipGoal
extends MoveToBlockGoal {
    private final SimplyCatEntity cat;
    protected int ticksWaited;
    private boolean gotCatnip;

    public CatSeekCatnipGoal(SimplyCatEntity cat, double speed, int searchDistance) {
        super((PathfinderMob)cat, speed, searchDistance, 2);
        this.cat = cat;
    }

    public boolean m_8036_() {
        this.gotCatnip = false;
        return super.m_8036_() && this.cat.m_217043_().m_188503_(3) == 0;
    }

    public boolean m_8045_() {
        return this.gotCatnip && super.m_8045_();
    }

    public boolean m_8064_() {
        return this.f_25601_ % 100 == 0;
    }

    public double m_8052_() {
        return 2.0;
    }

    protected boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
        if (!this.gotCatnip) {
            BlockState blockState = levelReader.m_8055_(blockPos);
            this.gotCatnip = blockState.m_60713_((Block)SCBlocks.CATNIP_CROP.get()) && (Integer)blockState.m_61143_((Property)CatnipBlock.AGE) >= 1 || blockState.m_60713_((Block)SCBlocks.POTTED_CATNIP.get());
        }
        return this.gotCatnip;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_()) {
            if (this.ticksWaited >= 40) {
                this.onReachedTarget();
            } else {
                ++this.ticksWaited;
            }
        }
    }

    private void onReachedTarget() {
        Level level = this.cat.m_9236_();
        if (this.cat.m_217043_().m_188501_() <= 0.2f && this.gotCatnip && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)this.cat)) {
            BlockState blockState = level.m_8055_(this.f_25602_);
            if (blockState.m_60734_() instanceof CatnipBlock) {
                int age = (Integer)blockState.m_61143_((Property)CatnipBlock.AGE);
                if (age > 0) {
                    level.m_7731_(this.f_25602_, (BlockState)blockState.m_61124_((Property)CatnipBlock.AGE, (Comparable)Integer.valueOf(age - 1)), 2);
                }
            } else if (blockState.m_60713_((Block)SCBlocks.POTTED_CATNIP.get())) {
                CatnipBlock.m_49840_((Level)level, (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)SCItems.CATNIP_SEEDS.get()));
                level.m_7731_(this.f_25602_, Blocks.f_50276_.m_49966_(), 3);
            }
            level.m_46796_(2001, this.f_25602_, CatnipBlock.m_49956_((BlockState)blockState));
        }
        this.gotCatnip = false;
        this.f_25600_ = 10;
    }

    public void m_8056_() {
        this.ticksWaited = 0;
        super.m_8056_();
    }
}

