/*
 * Decompiled with CFR 0.152.
 */
package com.tatnux.crafter.modules.crafter.data;

import com.tatnux.crafter.modules.crafter.blocks.inventory.WorkingCraftingInventory;
import com.tatnux.crafter.modules.crafter.data.CraftMode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class CrafterRecipe
implements INBTSerializable<CompoundTag> {
    private final CraftingContainer inv = new WorkingCraftingInventory();
    private CraftingRecipe recipe;
    private ItemStack output = ItemStack.f_41583_;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private CraftMode craftMode = CraftMode.EXT;

    public void setCraftingGrid(List<ItemStack> items, ItemStack output) {
        if (items.size() > this.items.size()) {
            throw new IllegalArgumentException("The size of the items array exceeds the size of the recipe items list.");
        }
        for (int i = 0; i < items.size(); ++i) {
            ItemStack itemStack = items.get(i);
            this.inv.m_6836_(i, itemStack);
            this.items.set(i, (Object)itemStack);
        }
        this.output = output;
    }

    public static Optional<CraftingRecipe> findRecipe(Level level, CraftingContainer container) {
        return level.m_7465_().m_44051_().stream().filter(Objects::nonNull).filter(recipe -> {
            CraftingRecipe craftingRecipe;
            return recipe instanceof CraftingRecipe && (craftingRecipe = (CraftingRecipe)recipe).m_5818_((Container)container, level);
        }).map(recipe1 -> (CraftingRecipe)recipe1).findFirst();
    }

    public CompoundTag serializeNBT() {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            itemStack.m_41739_(itemTag);
            listTag.add((Object)itemTag);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Items", (Tag)listTag);
        if (!this.output.m_41619_()) {
            tag.m_128365_("Output", (Tag)this.output.serializeNBT());
        }
        tag.m_128344_("CraftMode", (byte)this.craftMode.ordinal());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag listTag = nbt.m_128437_("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag itemTags = listTag.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTags);
            this.inv.m_6836_(slot, itemStack);
            this.items.set(slot, (Object)itemStack);
        }
        this.output = nbt.m_128441_("Output") ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Output")) : ItemStack.f_41583_;
        this.craftMode = CraftMode.values()[nbt.m_128445_("CraftMode")];
    }

    public Optional<CraftingRecipe> getCachedRecipe(Level level) {
        return Optional.ofNullable(this.recipe).or(() -> CrafterRecipe.findRecipe(level, this.inv).map(craftingRecipe -> {
            this.recipe = craftingRecipe;
            return this.recipe;
        }));
    }

    @Generated
    public CrafterRecipe() {
    }

    @Generated
    public CraftingContainer getInv() {
        return this.inv;
    }

    @Generated
    public CraftingRecipe getRecipe() {
        return this.recipe;
    }

    @Generated
    public ItemStack getOutput() {
        return this.output;
    }

    @Generated
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Generated
    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    @Generated
    public void setRecipe(CraftingRecipe recipe) {
        this.recipe = recipe;
    }

    @Generated
    public void setOutput(ItemStack output) {
        this.output = output;
    }

    @Generated
    public void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    @Generated
    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrafterRecipe)) {
            return false;
        }
        CrafterRecipe other = (CrafterRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CraftingContainer this$inv = this.getInv();
        CraftingContainer other$inv = other.getInv();
        if (this$inv == null ? other$inv != null : !this$inv.equals(other$inv)) {
            return false;
        }
        CraftingRecipe this$recipe = this.getRecipe();
        CraftingRecipe other$recipe = other.getRecipe();
        if (this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe)) {
            return false;
        }
        ItemStack this$output = this.getOutput();
        ItemStack other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        NonNullList<ItemStack> this$items = this.getItems();
        NonNullList<ItemStack> other$items = other.getItems();
        if (this$items == null ? other$items != null : !this$items.equals(other$items)) {
            return false;
        }
        CraftMode this$craftMode = this.getCraftMode();
        CraftMode other$craftMode = other.getCraftMode();
        return !(this$craftMode == null ? other$craftMode != null : !((Object)((Object)this$craftMode)).equals((Object)other$craftMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CrafterRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CraftingContainer $inv = this.getInv();
        result = result * 59 + ($inv == null ? 43 : $inv.hashCode());
        CraftingRecipe $recipe = this.getRecipe();
        result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
        ItemStack $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        NonNullList<ItemStack> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : $items.hashCode());
        CraftMode $craftMode = this.getCraftMode();
        result = result * 59 + ($craftMode == null ? 43 : ((Object)((Object)$craftMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CrafterRecipe(inv=" + this.getInv() + ", recipe=" + this.getRecipe() + ", output=" + this.getOutput() + ", items=" + this.getItems() + ", craftMode=" + this.getCraftMode() + ")";
    }
}

