/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.CraftingContainerRecipeTransferHandlerServer;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiSlotAccessor;

public record ReiTransferRecipeMessage(ResourceLocation recipeId, ResourceLocation recipeTypeId, CompoundTag tag, List<Integer> inputSlots, List<Integer> inventorySlots, boolean maxTransfer) {
    public static void encode(ReiTransferRecipeMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130085_(msg.recipeId);
        packetBuffer.m_130085_(msg.recipeTypeId);
        packetBuffer.m_130079_(msg.tag);
        packetBuffer.m_236828_(msg.inputSlots, FriendlyByteBuf::m_130130_);
        packetBuffer.m_236828_(msg.inventorySlots, FriendlyByteBuf::m_130130_);
        packetBuffer.writeBoolean(msg.maxTransfer);
    }

    public static ReiTransferRecipeMessage decode(FriendlyByteBuf packetBuffer) {
        return new ReiTransferRecipeMessage(packetBuffer.m_130281_(), packetBuffer.m_130281_(), packetBuffer.m_130260_(), packetBuffer.m_236845_(FriendlyByteBuf::m_130242_), packetBuffer.m_236845_(FriendlyByteBuf::m_130242_), packetBuffer.readBoolean());
    }

    static void onMessage(ReiTransferRecipeMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ReiTransferRecipeMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    public static void handleMessage(ReiTransferRecipeMessage payload, @Nullable ServerPlayer player) {
        RecipeType recipeType = (RecipeType)BuiltInRegistries.f_256990_.m_7745_(payload.recipeTypeId);
        if (recipeType == null) {
            return;
        }
        AbstractContainerMenu container = player.f_36096_;
        List<InputIngredient<ItemStack>> inputs = ReiTransferRecipeMessage.readInputs(payload.tag.m_128437_("Inputs", 10));
        RecipeFinder recipeFinder = new RecipeFinder();
        for (int slotId : payload.inventorySlots) {
            ReiSlotAccessor slot = (ReiSlotAccessor)ReiSlotAccessor.fromSlot(container.m_38853_(slotId));
            recipeFinder.addNormalItem(slot.getItemStack());
        }
        NonNullList ingredients = NonNullList.m_122779_();
        for (InputIngredient<ItemStack> itemStacks : inputs) {
            ingredients.add((Object)CollectionUtils.toIngredient((Iterable)itemStacks.get()));
        }
        IntArrayList recipeItemIds = new IntArrayList();
        if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds)) {
            CraftingContainerRecipeTransferHandlerServer.setItemsWithStacks((Player)player, payload.recipeId, recipeType, recipeItemIds.intStream().mapToObj(RecipeFinder::getStackFromId).toList(), payload.inputSlots, payload.inventorySlots, payload.maxTransfer);
        }
    }

    private static List<InputIngredient<ItemStack>> readInputs(ListTag tag) {
        ArrayList<InputIngredient<ItemStack>> inputs = new ArrayList<InputIngredient<ItemStack>>();
        for (Tag t : tag) {
            CompoundTag compoundTag = (CompoundTag)t;
            InputIngredient stacks = InputIngredient.of((int)compoundTag.m_128451_("Index"), (List)EntryIngredient.read((ListTag)compoundTag.m_128437_("Ingredient", 10)));
            inputs.add((InputIngredient<ItemStack>)InputIngredient.withType((InputIngredient)stacks, (EntryType)VanillaEntryTypes.ITEM));
        }
        return inputs;
    }
}

