/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.misc;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingBlock;

public class MiniFigureBlock
extends RotatingBlock {
    public static final VoxelShape SHAPE = MiniFigureBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private final Supplier<SoundEvent> useSound;

    public MiniFigureBlock(BlockBehaviour.Properties pProperties) {
        this(null, pProperties);
    }

    public MiniFigureBlock(Supplier<SoundEvent> useSound, BlockBehaviour.Properties pProperties) {
        super(pProperties, b -> SHAPE);
        this.useSound = useSound;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_6144_()) {
            return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        SoundEvent sqeak = this.getSqueakSound(pLevel, pState, pPos);
        SoundEvent extra = this.getExtraSqueakSound(pLevel, pState, pPos);
        if (sqeak != null) {
            pLevel.m_5594_(pPlayer, pPos, sqeak, SoundSource.BLOCKS, 1.0f, 0.8f + pPlayer.m_217043_().m_188501_() * 0.4f);
        }
        if (extra != null) {
            pLevel.m_5594_(pPlayer, pPos, extra, SoundSource.BLOCKS, 0.8f, 1.1f + pPlayer.m_217043_().m_188501_() * 0.4f);
        }
        return InteractionResult.SUCCESS;
    }

    protected SoundEvent getSqueakSound(Level level, BlockState state, BlockPos pos) {
        return (SoundEvent)TDRegistry.SoundReg.MINI_FIGURE_SQUEAK.get();
    }

    protected SoundEvent getExtraSqueakSound(Level level, BlockState state, BlockPos pos) {
        return this.useSound != null ? this.useSound.get() : null;
    }
}

