/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingMultiblock;
import tanukidecor.block.entity.SingleSlotBlockEntity;
import tanukidecor.block.misc.IDisplayProvider;
import tanukidecor.util.MultiblockHandler;

public class SciencePodBlock
extends RotatingMultiblock
implements EntityBlock,
IDisplayProvider {
    private static final Vector3f DISPLAY_SCALE = new Vector3f(0.725f, 0.725f, 0.725f);
    public static final VoxelShape SHAPE_LOWER = Shapes.m_83124_((VoxelShape)SciencePodBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), (VoxelShape[])new VoxelShape[]{SciencePodBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)4.0, (double)11.0), SciencePodBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)4.0, (double)16.0), SciencePodBlock.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)});
    public static final VoxelShape SHAPE_MIDDLE = SciencePodBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE_UPPER = Shapes.m_83124_((VoxelShape)SciencePodBlock.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{SciencePodBlock.m_49796_((double)0.0, (double)12.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0), SciencePodBlock.m_49796_((double)5.0, (double)12.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0), SciencePodBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)});

    public SciencePodBlock(BlockBehaviour.Properties pProperties) {
        super(MultiblockHandler.MULTIBLOCK_1X3X1, SciencePodBlock::buildShape, pProperties);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockPos pos = this.getDelegatePos(pState, pPos);
        return SingleSlotBlockEntity.use(pState, pLevel, pos, pPlayer, pHand, pHit);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            SingleSlotBlockEntity.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Override
    public Vector3f getDisplayRotation(Level level, BlockState blockState, BlockPos blockPos, ItemStack itemStack, int renderPass, float partialTick) {
        return new Vector3f(0.0f, ((Direction)blockState.m_61143_((Property)FACING)).m_122424_().m_122435_(), 0.0f);
    }

    @Override
    public Vector3f getDisplayTranslation(Level level, BlockState blockState, BlockPos blockPos, ItemStack itemStack, int renderPass, float partialTick) {
        float time = (float)((int)(level.m_46467_() + Math.abs(blockState.m_60726_(blockPos)) % 96000L)) + partialTick;
        float dy = Mth.m_14031_((float)(time * 0.032f)) * 0.09f;
        return new Vector3f(0.0f, dy, 0.0f);
    }

    @Override
    public Vector3f getDisplayScale(Level level, BlockState blockState, BlockPos blockPos, ItemStack itemStack, int renderPass, float partialTick) {
        return DISPLAY_SCALE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (this.getMultiblockHandler().isCenterState(pState)) {
            return ((BlockEntityType)TDRegistry.BlockEntityReg.DISPLAY_CASE.get()).m_155264_(pPos, pState);
        }
        return ((BlockEntityType)TDRegistry.BlockEntityReg.STORAGE_DELEGATE.get()).m_155264_(pPos, pState);
    }

    public static VoxelShape buildShape(BlockState blockState) {
        Vec3i index = MultiblockHandler.MULTIBLOCK_1X3X1.getIndex(blockState);
        switch (index.m_123342_()) {
            case -1: {
                return SHAPE_LOWER;
            }
            case 0: {
                return SHAPE_MIDDLE;
            }
            case 1: {
                return SHAPE_UPPER;
            }
        }
        return Shapes.m_83144_();
    }
}

