/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.integration;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import tanukidecor.TDRegistry;
import tanukidecor.integration.JeiDIYRecipeCategory;
import tanukidecor.recipe.DIYRecipe;

@JeiPlugin
public class TDJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("tanukidecor", "jei");
    private static final TagKey<Item> DIY_BLACKLIST_TAG_KEY = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation("tanukidecor", "diy_blacklist"));

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JeiDIYRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Optional<RegistryAccess> oRegistryAccess = TDJeiPlugin.getClientRegistryAccess();
        if (oRegistryAccess.isEmpty()) {
            return;
        }
        List<DIYRecipe> recipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)TDRegistry.RecipeReg.DIY.get()).stream().filter(recipe -> !recipe.m_8043_((RegistryAccess)oRegistryAccess.get()).m_204117_(DIY_BLACKLIST_TAG_KEY)).toList();
        registration.addRecipes(JeiDIYRecipeCategory.RECIPE_TYPE, recipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TDRegistry.BlockReg.DIY_WORKBENCH.get()), new RecipeType[]{JeiDIYRecipeCategory.RECIPE_TYPE});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        Collection blacklistItems = ForgeRegistries.ITEMS.tags().getTag(DIY_BLACKLIST_TAG_KEY).stream().map(ItemStack::new).collect(Collectors.toSet());
        if (!blacklistItems.isEmpty()) {
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, blacklistItems);
        }
    }

    public static Optional<RegistryAccess> getClientRegistryAccess() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91073_).map(Level::m_9598_);
    }
}

