/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.util;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluids;

@Immutable
public class MultiblockHandler {
    public static final Direction ORIGIN_DIRECTION = Direction.NORTH;
    public static final Vec3i CENTER_INDEX = Vec3i.f_123288_;
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String DEPTH = "depth";
    protected static final IntegerProperty WIDTH_1_2 = IntegerProperty.m_61631_((String)"width", (int)1, (int)2);
    protected static final IntegerProperty WIDTH_0_2 = IntegerProperty.m_61631_((String)"width", (int)0, (int)2);
    protected static final IntegerProperty HEIGHT_1_2 = IntegerProperty.m_61631_((String)"height", (int)1, (int)2);
    protected static final IntegerProperty HEIGHT_0_2 = IntegerProperty.m_61631_((String)"height", (int)0, (int)2);
    protected static final IntegerProperty DEPTH_1_2 = IntegerProperty.m_61631_((String)"depth", (int)1, (int)2);
    protected static final IntegerProperty DEPTH_0_2 = IntegerProperty.m_61631_((String)"depth", (int)0, (int)2);
    protected static final IntegerProperty[] WIDTH_BY_MAX_VALUE = new IntegerProperty[]{null, WIDTH_1_2, WIDTH_0_2};
    protected static final IntegerProperty[] HEIGHT_BY_MAX_VALUE = new IntegerProperty[]{null, HEIGHT_1_2, HEIGHT_0_2};
    protected static final IntegerProperty[] DEPTH_BY_MAX_VALUE = new IntegerProperty[]{null, DEPTH_1_2, DEPTH_0_2};
    public static final MultiblockHandler MULTIBLOCK_3X3X3 = new MultiblockHandler(3, 3, 3);
    public static final MultiblockHandler MULTIBLOCK_3X3X1 = new MultiblockHandler(3, 3, 1);
    public static final MultiblockHandler MULTIBLOCK_3X2X1 = new MultiblockHandler(3, 2, 1);
    public static final MultiblockHandler MULTIBLOCK_3X1X1 = new MultiblockHandler(3, 1, 1);
    public static final MultiblockHandler MULTIBLOCK_3X1X2 = new MultiblockHandler(3, 1, 2);
    public static final MultiblockHandler MULTIBLOCK_3X1X3 = new MultiblockHandler(3, 1, 3);
    public static final MultiblockHandler MULTIBLOCK_2X3X1 = new MultiblockHandler(2, 3, 1);
    public static final MultiblockHandler MULTIBLOCK_2X2X2 = new MultiblockHandler(2, 2, 2);
    public static final MultiblockHandler MULTIBLOCK_2X2X1 = new MultiblockHandler(2, 2, 1);
    public static final MultiblockHandler MULTIBLOCK_2X1X2 = new MultiblockHandler(2, 1, 2);
    public static final MultiblockHandler MULTIBLOCK_2X1X1 = new MultiblockHandler(2, 1, 1);
    public static final MultiblockHandler MULTIBLOCK_1X3X1 = new MultiblockHandler(1, 3, 1);
    public static final MultiblockHandler MULTIBLOCK_1X1X2 = new MultiblockHandler(1, 1, 2);
    @Nullable
    protected final IntegerProperty widthProperty;
    @Nullable
    protected final IntegerProperty heightProperty;
    @Nullable
    protected final IntegerProperty depthProperty;
    protected final Vec3i dimensions;
    protected final Vec3i minIndex;
    protected final Vec3i maxIndex;
    protected final Map<Direction, BoundingBox> bounds;

    public MultiblockHandler(int width, int height, int depth) {
        if (width < 1 || height < 1 || depth < 1) {
            throw new IllegalArgumentException(String.format("[MultiblockHandler] width, height, and depth must be greater than zero! Provided [{}, {}, {}]", width, height, depth));
        }
        this.dimensions = new Vec3i(width, height, depth);
        this.minIndex = new Vec3i(-(width - 1) / 2, -(height - 1) / 2, -(depth - 1) / 2);
        this.maxIndex = new Vec3i(width / 2, height / 2, depth / 2);
        this.widthProperty = MultiblockHandler.getWidthProperty(width);
        this.heightProperty = MultiblockHandler.getHeightProperty(height);
        this.depthProperty = MultiblockHandler.getDepthProperty(depth);
        BoundingBox boundingBox = BoundingBox.m_162375_((Vec3i)this.minIndex, (Vec3i)this.maxIndex);
        this.bounds = MultiblockHandler.createRotatedBoundingBoxMap(boundingBox, ORIGIN_DIRECTION);
    }

    @Nullable
    public IntegerProperty getWidthProperty() {
        return this.widthProperty;
    }

    @Nullable
    public IntegerProperty getHeightProperty() {
        return this.heightProperty;
    }

    @Nullable
    public IntegerProperty getDepthProperty() {
        return this.depthProperty;
    }

    public Vec3i getDimensions() {
        return new Vec3i(this.dimensions.m_123341_(), this.dimensions.m_123342_(), this.dimensions.m_123343_());
    }

    public Vec3i getMinIndex() {
        return new Vec3i(this.minIndex.m_123341_(), this.minIndex.m_123342_(), this.minIndex.m_123343_());
    }

    public Vec3i getMaxIndex() {
        return new Vec3i(this.maxIndex.m_123341_(), this.maxIndex.m_123342_(), this.maxIndex.m_123343_());
    }

    public BoundingBox getBounds(Direction direction) {
        return this.bounds.get(direction);
    }

    public BlockPos getCenterPos(BlockPos pos, BlockState blockState, Direction direction) {
        return MultiblockHandler.getCenterPos(pos, this.getIndex(blockState), direction);
    }

    public BlockPos getMin(BlockPos center, Direction direction) {
        return center.m_121955_(MultiblockHandler.indexToOffset(this.minIndex, direction));
    }

    public BlockPos getMax(BlockPos center, Direction direction) {
        return center.m_121955_(MultiblockHandler.indexToOffset(this.maxIndex, direction));
    }

    public Iterable<BlockPos> getPositions(BlockPos center, Direction facing) {
        BlockPos min = this.getMin(center, facing);
        BlockPos max = this.getMax(center, facing);
        return BlockPos.m_121940_((BlockPos)min, (BlockPos)max);
    }

    @Nullable
    public static IntegerProperty getWidthProperty(int maxWidth) {
        int index = Mth.m_14045_((int)(maxWidth - 1), (int)0, (int)(WIDTH_BY_MAX_VALUE.length - 1));
        return WIDTH_BY_MAX_VALUE[index];
    }

    @Nullable
    public static IntegerProperty getHeightProperty(int maxHeight) {
        int index = Mth.m_14045_((int)(maxHeight - 1), (int)0, (int)(HEIGHT_BY_MAX_VALUE.length - 1));
        return HEIGHT_BY_MAX_VALUE[index];
    }

    @Nullable
    public static IntegerProperty getDepthProperty(int maxDepth) {
        int index = Mth.m_14045_((int)(maxDepth - 1), (int)0, (int)(DEPTH_BY_MAX_VALUE.length - 1));
        return DEPTH_BY_MAX_VALUE[index];
    }

    public boolean isCenterState(BlockState blockState) {
        return this.getIndex(blockState).equals((Object)CENTER_INDEX);
    }

    public StateDefinition.Builder<Block, BlockState> createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.widthProperty != null) {
            builder.m_61104_(new Property[]{this.widthProperty});
        }
        if (this.heightProperty != null) {
            builder.m_61104_(new Property[]{this.heightProperty});
        }
        if (this.depthProperty != null) {
            builder.m_61104_(new Property[]{this.depthProperty});
        }
        return builder;
    }

    public BlockState getCenterState(BlockState blockState) {
        return this.getIndexedState(blockState, CENTER_INDEX);
    }

    public Vec3i getIndex(BlockState blockState) {
        int width = this.widthProperty != null ? (Integer)blockState.m_61143_((Property)this.widthProperty) - this.dimensions.m_123341_() / 2 : 0;
        int height = this.heightProperty != null ? (Integer)blockState.m_61143_((Property)this.heightProperty) - this.dimensions.m_123342_() / 2 : 0;
        int depth = this.depthProperty != null ? (Integer)blockState.m_61143_((Property)this.depthProperty) - this.dimensions.m_123343_() / 2 : 0;
        return new Vec3i(width, height, depth);
    }

    public BlockState getIndexedState(BlockState blockState, Vec3i index) {
        BlockState mutableBlockState = blockState;
        if (this.widthProperty != null) {
            mutableBlockState = (BlockState)mutableBlockState.m_61124_((Property)this.widthProperty, (Comparable)Integer.valueOf(index.m_123341_() + this.dimensions.m_123341_() / 2));
        }
        if (this.heightProperty != null) {
            mutableBlockState = (BlockState)mutableBlockState.m_61124_((Property)this.heightProperty, (Comparable)Integer.valueOf(index.m_123342_() + this.dimensions.m_123342_() / 2));
        }
        if (this.depthProperty != null) {
            mutableBlockState = (BlockState)mutableBlockState.m_61124_((Property)this.depthProperty, (Comparable)Integer.valueOf(index.m_123343_() + this.dimensions.m_123343_() / 2));
        }
        return mutableBlockState;
    }

    public void onBlockPlaced(Level level, BlockPos pos, BlockState blockState, Direction direction) {
        BlockPos center = this.getCenterPos(pos, blockState, direction);
        this.iterateIndices(index -> {
            if (index.equals((Object)CENTER_INDEX)) {
                return;
            }
            BlockPos p = center.m_121955_(MultiblockHandler.indexToOffset(index, direction));
            boolean waterlogged = level.m_6425_(p).m_76152_() == Fluids.f_76193_;
            BlockState state = this.getIndexedState((BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged)), (Vec3i)index);
            level.m_7731_(p, state, 3);
        });
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context, BlockState blockState, Direction facing) {
        Level level = context.m_43725_();
        BlockPos center = context.m_8083_();
        if (!this.allPositions(center, facing, p -> level.m_46739_(p) && level.m_8055_(p).m_60629_(context))) {
            return null;
        }
        return this.getCenterState(blockState);
    }

    public boolean canSurvive(BlockState blockState, LevelReader level, BlockPos pos, Direction facing) {
        return this.allPositions(this.getCenterPos(pos, blockState, facing), facing, p -> level.m_8055_(p).m_60713_(blockState.m_60734_()));
    }

    public void preventCreativeDropFromCenterPart(Level level, BlockPos pos, BlockState blockState, Direction facing, Player player) {
        BlockPos origin = this.getCenterPos(pos, blockState, facing);
        BlockState originState = level.m_8055_(origin);
        if (originState.m_60713_(blockState.m_60734_()) && this.getIndex(originState).equals((Object)CENTER_INDEX)) {
            level.m_7731_(origin, originState.m_60819_().m_76188_(), 35);
        }
    }

    public boolean allPositions(BlockPos center, Direction facing, Predicate<BlockPos> predicate) {
        for (BlockPos p : this.getPositions(center, facing)) {
            if (predicate.test(p)) continue;
            return false;
        }
        return true;
    }

    public boolean anyPositions(BlockPos center, Direction facing, Predicate<BlockPos> predicate) {
        for (BlockPos p : this.getPositions(center, facing)) {
            if (!predicate.test(p)) continue;
            return true;
        }
        return false;
    }

    public void iterateIndices(Consumer<Vec3i> consumer) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = this.minIndex.m_123341_(); x <= this.maxIndex.m_123341_(); ++x) {
            for (int y = this.minIndex.m_123342_(); y <= this.maxIndex.m_123342_(); ++y) {
                for (int z = this.minIndex.m_123343_(); z <= this.maxIndex.m_123343_(); ++z) {
                    consumer.accept((Vec3i)mutable.m_122178_(x, y, z));
                }
            }
        }
    }

    protected static Map<Direction, BoundingBox> createRotatedBoundingBoxMap(BoundingBox boundingBox, Direction from) {
        EnumMap<Direction, BoundingBox> map = new EnumMap<Direction, BoundingBox>(Direction.class);
        map.put(from, boundingBox);
        BoundingBox box = boundingBox;
        for (int i = 0; i < 3; ++i) {
            Direction direction = Direction.m_122407_((int)(from.m_122416_() + i + 1));
            box = new BoundingBox(1 - box.m_162401_(), box.m_162396_(), box.m_162395_(), 1 - box.m_162398_(), box.m_162400_(), box.m_162399_());
            map.put(direction, box);
        }
        return map;
    }

    public static BlockPos getCenterPos(BlockPos pos, Vec3i index, Direction direction) {
        Vec3i offset = MultiblockHandler.indexToOffset(index, direction);
        return pos.m_121996_(offset);
    }

    public static Vec3i indexToOffset(Vec3i index, Direction direction) {
        switch (direction) {
            default: {
                return new Vec3i(-index.m_123341_(), index.m_123342_(), index.m_123343_());
            }
            case EAST: {
                return new Vec3i(-index.m_123343_(), index.m_123342_(), -index.m_123341_());
            }
            case SOUTH: {
                return new Vec3i(index.m_123341_(), index.m_123342_(), -index.m_123343_());
            }
            case WEST: 
        }
        return new Vec3i(index.m_123343_(), index.m_123342_(), index.m_123341_());
    }
}

