/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.math;

import org.watermedia.api.WaterMediaAPI;
import org.watermedia.loaders.ILoader;

public class MathAPI
extends WaterMediaAPI {
    public static long tickToMs(long ticks) {
        return ticks * 50L;
    }

    public static int tickToMs(float partialTicks) {
        return (int)(partialTicks * 50.0f);
    }

    public static int msToTick(long ms) {
        return (int)(ms / 50L);
    }

    public static double scaleTempo(long start, long end, long time) {
        if (start < 0L || end < 0L || time < 0L) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        long duration = end - start;
        long realTime = time - start;
        if (realTime == 0L || duration == 0L) {
            return 0.0;
        }
        long result = realTime / duration;
        if (realTime > duration) {
            result %= duration;
        }
        return result;
    }

    public static double scaleTempo(double start, double end, double time) {
        if (start < 0.0 || end < 0.0 || time < 0.0) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        double duration = end - start;
        double realTime = time - start;
        if (realTime == 0.0 || duration == 0.0) {
            return 0.0;
        }
        double result = realTime / duration;
        if (realTime > duration) {
            result %= duration;
        }
        return result;
    }

    public static double scaleTempoTick(int startTick, int endTick, int timeTick) {
        return MathAPI.scaleTempo(MathAPI.tickToMs(startTick), MathAPI.tickToMs(endTick), MathAPI.tickToMs(timeTick));
    }

    public static double scaleDesTempo(long start, long end, long time) {
        if (start < 0L || end < 0L || time < 0L) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        long duration = end - start;
        long realTime = time - start;
        if (realTime == 0L || duration == 0L) {
            return 0.0;
        }
        return (double)realTime / (double)duration;
    }

    public static double scaleDesTempo(double start, double end, double time) {
        if (start < 0.0 || end < 0.0 || time < 0.0) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        double duration = end - start;
        double realTime = time - start;
        if (realTime == 0.0 || duration == 0.0) {
            return 0.0;
        }
        double result = realTime / duration;
        return Double.isNaN(result) ? 0.0 : result;
    }

    public static double scaleDesTempoTick(int startTick, int endTick, int timeTick) {
        return MathAPI.scaleTempo(MathAPI.tickToMs(startTick), MathAPI.tickToMs(endTick), MathAPI.tickToMs(timeTick));
    }

    public static long floorMod(long x, long y) {
        if (x == 0L || y == 0L) {
            return 0L;
        }
        long r = x % y;
        if ((x ^ y) < 0L && r != 0L) {
            return r + y;
        }
        return r;
    }

    public static int floorMod(int x, int y) {
        if (x == 0 || y == 0) {
            return 0;
        }
        int r = x % y;
        if ((x ^ y) < 0 && r != 0) {
            return r + y;
        }
        return r;
    }

    public static int floorMod(long x, int y) {
        return (int)MathAPI.floorMod(x, (long)y);
    }

    public static int floorMod(int x, long y) {
        return (int)MathAPI.floorMod((long)x, y);
    }

    public static short min(short a, short b) {
        return a <= b ? a : b;
    }

    public static byte min(byte a, byte b) {
        return a <= b ? a : b;
    }

    public static int argb(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    @Deprecated(forRemoval=true)
    public static int getColorARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static double easeIn(double start, double end, double t) {
        return start + (end - start) * t * t;
    }

    public static double easeOut(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.pow(1.0 - t, 2.0));
    }

    public static double easeInOut(double start, double end, double t) {
        return t < 0.5 ? MathAPI.easeIn(start, end / 2.0, t * 2.0) : MathAPI.easeOut(start + end / 2.0, end, (t - 0.5) * 2.0);
    }

    public static double easeOutIn(double start, double end, double t) {
        return t < 0.5 ? MathAPI.easeOut(start, end / 2.0, t * 2.0) : MathAPI.easeIn(start + end / 2.0, end, (t - 0.5) * 2.0);
    }

    public static double easeInCircle(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.sqrt(1.0 - t * t));
    }

    public static double easeOutCircle(double start, double end, double t) {
        return start + (end - start) * Math.sqrt(1.0 - Math.pow(t - 1.0, 2.0));
    }

    public static double easyEase(double start, double end, double t) {
        return start + (end - start) * (t < 0.5 ? 2.0 * t * t : -1.0 + 2.0 * t * (2.0 - t));
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.LOWEST;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        return true;
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
    }

    @Override
    public void release() {
    }
}

