/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.media;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_media_slave_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.media.MediaSlave;
import org.watermedia.videolan4j.media.MediaSlaveType;

final class MediaSlaves {
    private MediaSlaves() {
    }

    static List<MediaSlave> getMediaSlaves(libvlc_media_t media) {
        PointerByReference slavesPointer = new PointerByReference();
        int numberOfSlaves = LibVlc.libvlc_media_slaves_get(media, slavesPointer);
        ArrayList<MediaSlave> result = new ArrayList<MediaSlave>(numberOfSlaves);
        if (numberOfSlaves > 0) {
            Pointer[] pointers;
            for (Pointer pointer : pointers = slavesPointer.getValue().getPointerArray(0L, numberOfSlaves)) {
                libvlc_media_slave_t slave = new libvlc_media_slave_t(pointer);
                result.add(new MediaSlave(VideoLan4J.copyNativeString(slave.psz_uri), MediaSlaveType.mediaSlaveType(slave.i_type), slave.i_priority));
            }
        }
        LibVlc.libvlc_media_slaves_release(slavesPointer.getValue(), numberOfSlaves);
        return result;
    }
}

