/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript;

import java.lang.reflect.Array;
import java.util.Objects;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.NativeJavaObject;
import org.watermedia.shaded.mozilla.javascript.ScriptRuntime;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.ScriptableObject;
import org.watermedia.shaded.mozilla.javascript.Symbol;
import org.watermedia.shaded.mozilla.javascript.SymbolKey;
import org.watermedia.shaded.mozilla.javascript.SymbolScriptable;
import org.watermedia.shaded.mozilla.javascript.Undefined;
import org.watermedia.shaded.mozilla.javascript.Wrapper;

public class NativeJavaArray
extends NativeJavaObject
implements SymbolScriptable {
    private static final long serialVersionUID = -924022554283675333L;
    Object array;
    int length;
    Class<?> cls;

    @Override
    public String getClassName() {
        return "JavaArray";
    }

    public static NativeJavaArray wrap(Scriptable scope, Object array) {
        return new NativeJavaArray(scope, array);
    }

    @Override
    public Object unwrap() {
        return this.array;
    }

    public NativeJavaArray(Scriptable scope, Object array) {
        super(scope, null, ScriptRuntime.ObjectClass);
        Class<?> cl = array.getClass();
        if (!cl.isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.array = array;
        this.length = Array.getLength(array);
        this.cls = cl.getComponentType();
    }

    @Override
    public boolean has(String id2, Scriptable start) {
        return id2.equals("length") || super.has(id2, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return 0 <= index && index < this.length;
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        return SymbolKey.IS_CONCAT_SPREADABLE.equals(key);
    }

    @Override
    public Object get(String id2, Scriptable start) {
        if (id2.equals("length")) {
            return this.length;
        }
        Object result = super.get(id2, start);
        if (result == NOT_FOUND && !ScriptableObject.hasProperty(this.getPrototype(), id2)) {
            throw Context.reportRuntimeErrorById("msg.java.member.not.found", this.array.getClass().getName(), id2);
        }
        return result;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (0 <= index && index < this.length) {
            Context cx = Context.getContext();
            Object obj = Array.get(this.array, index);
            return cx.getWrapFactory().wrap(cx, this, obj, this.cls);
        }
        return Undefined.instance;
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return Boolean.TRUE;
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public void put(String id2, Scriptable start, Object value) {
        if (!id2.equals("length")) {
            throw Context.reportRuntimeErrorById("msg.java.array.member.not.found", id2);
        }
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (0 > index || index >= this.length) {
            throw Context.reportRuntimeErrorById("msg.java.array.index.out.of.bounds", String.valueOf(index), String.valueOf(this.length - 1));
        }
        Array.set(this.array, index, Context.jsToJava(value, this.cls));
    }

    @Override
    public void delete(Symbol key) {
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.array.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object[] getIds() {
        Object[] result = new Object[this.length];
        int i = this.length;
        while (--i >= 0) {
            result[i] = i;
        }
        return result;
    }

    @Override
    public boolean hasInstance(Scriptable value) {
        if (!(value instanceof Wrapper)) {
            return false;
        }
        Object instance = ((Wrapper)((Object)value)).unwrap();
        return this.cls.isInstance(instance);
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null) {
            this.prototype = ScriptableObject.getArrayPrototype(this.getParentScope());
        }
        return this.prototype;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NativeJavaArray && Objects.equals(((NativeJavaArray)obj).array, this.array);
    }

    @Override
    public int hashCode() {
        return this.array == null ? 0 : this.array.hashCode();
    }
}

