/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;

public abstract class Info
implements Serializable {
    private final int serviceId;
    private final String id;
    private final String url;
    private String originalUrl;
    private final String name;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    public void addError(Throwable throwable) {
        this.errors.add(throwable);
    }

    public void addAllErrors(Collection<Throwable> throwables) {
        this.errors.addAll(throwables);
    }

    public Info(int serviceId, String id2, String url, String originalUrl, String name) {
        this.serviceId = serviceId;
        this.id = id2;
        this.url = url;
        this.originalUrl = originalUrl;
        this.name = name;
    }

    public Info(int serviceId, LinkHandler linkHandler, String name) {
        this(serviceId, linkHandler.getId(), linkHandler.getUrl(), linkHandler.getOriginalUrl(), name);
    }

    public String toString() {
        String ifDifferentString = this.url.equals(this.originalUrl) ? "" : " (originalUrl=\"" + this.originalUrl + "\")";
        return this.getClass().getSimpleName() + "[url=\"" + this.url + "\"" + ifDifferentString + ", name=\"" + this.name + "\"]";
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public StreamingService getService() {
        try {
            return NewPipe.getService(this.serviceId);
        }
        catch (ExtractionException e) {
            throw new RuntimeException("Info object has invalid service id", e);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public String getName() {
        return this.name;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }
}

