/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;

public enum MediaFormat {
    MPEG_4(0, "MPEG-4", "mp4", "video/mp4"),
    v3GPP(16, "3GPP", "3gp", "video/3gpp"),
    WEBM(32, "WebM", "webm", "video/webm"),
    M4A(256, "m4a", "m4a", "audio/mp4"),
    WEBMA(512, "WebM", "webm", "audio/webm"),
    MP3(768, "MP3", "mp3", "audio/mpeg"),
    MP2(784, "MP2", "mp2", "audio/mpeg"),
    OPUS(1024, "opus", "opus", "audio/opus"),
    OGG(1280, "ogg", "ogg", "audio/ogg"),
    WEBMA_OPUS(512, "WebM Opus", "webm", "audio/webm"),
    AIFF(1536, "AIFF", "aiff", "audio/aiff"),
    AIF(1536, "AIFF", "aif", "audio/aiff"),
    WAV(1792, "WAV", "wav", "audio/wav"),
    FLAC(2048, "FLAC", "flac", "audio/flac"),
    ALAC(2304, "ALAC", "alac", "audio/alac"),
    VTT(4096, "WebVTT", "vtt", "text/vtt"),
    TTML(8192, "Timed Text Markup Language", "ttml", "application/ttml+xml"),
    TRANSCRIPT1(12288, "TranScript v1", "srv1", "text/xml"),
    TRANSCRIPT2(16384, "TranScript v2", "srv2", "text/xml"),
    TRANSCRIPT3(20480, "TranScript v3", "srv3", "text/xml"),
    SRT(24576, "SubRip file format", "srt", "text/srt");

    public final int id;
    @Nonnull
    public final String name;
    @Nonnull
    public final String suffix;
    @Nonnull
    public final String mimeType;

    private MediaFormat(@Nonnull int id2, @Nonnull String name, String suffix, String mimeType) {
        this.id = id2;
        this.name = name;
        this.suffix = suffix;
        this.mimeType = mimeType;
    }

    private static <T> T getById(int id2, Function<MediaFormat, T> field, T orElse) {
        return Arrays.stream(MediaFormat.values()).filter(mediaFormat -> mediaFormat.id == id2).map(field).findFirst().orElse(orElse);
    }

    @Nonnull
    public static String getNameById(int id2) {
        return MediaFormat.getById(id2, MediaFormat::getName, "");
    }

    @Nonnull
    public static String getSuffixById(int id2) {
        return MediaFormat.getById(id2, MediaFormat::getSuffix, "");
    }

    @Nullable
    public static String getMimeById(int id2) {
        return MediaFormat.getById(id2, MediaFormat::getMimeType, null);
    }

    @Nullable
    public static MediaFormat getFromMimeType(String mimeType) {
        return Arrays.stream(MediaFormat.values()).filter(mediaFormat -> mediaFormat.mimeType.equals(mimeType)).findFirst().orElse(null);
    }

    @Nonnull
    public static List<MediaFormat> getAllFromMimeType(String mimeType) {
        return Arrays.stream(MediaFormat.values()).filter(mediaFormat -> mediaFormat.mimeType.equals(mimeType)).collect(Collectors.toList());
    }

    @Nullable
    public static MediaFormat getFormatById(int id2) {
        return MediaFormat.getById(id2, mediaFormat -> mediaFormat, null);
    }

    @Nullable
    public static MediaFormat getFromSuffix(String suffix) {
        return Arrays.stream(MediaFormat.values()).filter(mediaFormat -> mediaFormat.suffix.equals(suffix)).findFirst().orElse(null);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getSuffix() {
        return this.suffix;
    }

    @Nonnull
    public String getMimeType() {
        return this.mimeType;
    }
}

