/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.com.grack.nanojson.JsonStringWriter;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ImageSuffix;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class BandcampExtractorHelper {
    private static final List<ImageSuffix> IMAGE_URL_SUFFIXES_AND_RESOLUTIONS = List.of(new ImageSuffix("10.jpg", -1, 1200, Image.ResolutionLevel.HIGH), new ImageSuffix("101.jpg", 90, -1, Image.ResolutionLevel.LOW), new ImageSuffix("170.jpg", 422, -1, Image.ResolutionLevel.MEDIUM), new ImageSuffix("171.jpg", 646, -1, Image.ResolutionLevel.MEDIUM), new ImageSuffix("20.jpg", -1, 1024, Image.ResolutionLevel.HIGH), new ImageSuffix("200.jpg", 420, -1, Image.ResolutionLevel.MEDIUM), new ImageSuffix("201.jpg", 280, -1, Image.ResolutionLevel.MEDIUM), new ImageSuffix("202.jpg", 140, -1, Image.ResolutionLevel.LOW), new ImageSuffix("204.jpg", 360, -1, Image.ResolutionLevel.MEDIUM), new ImageSuffix("205.jpg", 240, -1, Image.ResolutionLevel.MEDIUM), new ImageSuffix("206.jpg", 180, -1, Image.ResolutionLevel.MEDIUM), new ImageSuffix("207.jpg", 120, -1, Image.ResolutionLevel.LOW), new ImageSuffix("43.jpg", 100, -1, Image.ResolutionLevel.LOW), new ImageSuffix("44.jpg", 200, -1, Image.ResolutionLevel.MEDIUM));
    private static final String IMAGE_URL_APPENDIX_AND_EXTENSION_REGEX = "_\\d+\\.\\w+";
    private static final String IMAGES_DOMAIN_AND_PATH = "https://f4.bcbits.com/img/";
    public static final String BASE_URL = "https://bandcamp.com";
    public static final String BASE_API_URL = "https://bandcamp.com/api";

    private BandcampExtractorHelper() {
    }

    public static String getStreamUrlFromIds(long bandId, long itemId, String itemType) throws ParsingException {
        try {
            String jsonString = NewPipe.getDownloader().get("https://bandcamp.com/api/mobile/22/tralbum_details?band_id=" + bandId + "&tralbum_id=" + itemId + "&tralbum_type=" + itemType.charAt(0)).responseBody();
            return Utils.replaceHttpWithHttps(JsonParser.object().from(jsonString).getString("bandcamp_url"));
        }
        catch (IOException | JsonParserException | ReCaptchaException e) {
            throw new ParsingException("Ids could not be translated to URL", e);
        }
    }

    public static JsonObject getArtistDetails(String id2) throws ParsingException {
        try {
            return JsonParser.object().from(NewPipe.getDownloader().postWithContentTypeJson("https://bandcamp.com/api/mobile/22/band_details", Collections.emptyMap(), ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("band_id", id2)).end()).done().getBytes(StandardCharsets.UTF_8)).responseBody());
        }
        catch (IOException | JsonParserException | ReCaptchaException e) {
            throw new ParsingException("Could not download band details", e);
        }
    }

    @Nonnull
    public static String getImageUrl(long id2, boolean isAlbum) {
        return IMAGES_DOMAIN_AND_PATH + (Serializable)(isAlbum ? Character.valueOf('a') : "") + id2 + "_10.jpg";
    }

    public static boolean isArtistDomain(String url) throws ParsingException {
        if (url.toLowerCase().matches("https?://.+\\.bandcamp\\.com(/.*)?")) {
            return true;
        }
        if (url.toLowerCase().matches("https?://bandcamp\\.com(/.*)?")) {
            return false;
        }
        try {
            return ((Element)((Element)Jsoup.parse(NewPipe.getDownloader().get(Utils.replaceHttpWithHttps(url)).responseBody()).getElementsByClass("cart-wrapper").get(0)).getElementsByTag("a").get(0)).attr("href").equals("https://bandcamp.com/cart");
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return false;
        }
        catch (IOException | ReCaptchaException e) {
            throw new ParsingException("Could not determine whether URL is custom domain (not available? network error?)");
        }
    }

    public static boolean isRadioUrl(String url) {
        return url.toLowerCase().matches("https?://bandcamp\\.com/\\?show=\\d+");
    }

    public static DateWrapper parseDate(String textDate) throws ParsingException {
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(textDate, DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH));
            return new DateWrapper(zonedDateTime.toOffsetDateTime(), false);
        }
        catch (DateTimeException e) {
            throw new ParsingException("Could not parse date '" + textDate + "'", e);
        }
    }

    @Nonnull
    public static List<Image> getImagesFromSearchResult(@Nonnull Element searchResult) {
        return BandcampExtractorHelper.getImagesFromImageUrl(searchResult.getElementsByClass("art").stream().flatMap(element -> element.getElementsByTag("img").stream()).map(element -> element.attr("src")).filter(imageUrl -> !Utils.isNullOrEmpty(imageUrl)).findFirst().orElse(""));
    }

    @Nonnull
    public static List<Image> getImagesFromImageUrl(@Nullable String imageUrl) {
        if (Utils.isNullOrEmpty(imageUrl)) {
            return List.of();
        }
        return BandcampExtractorHelper.getImagesFromImageBaseUrl(imageUrl.replaceFirst(IMAGE_URL_APPENDIX_AND_EXTENSION_REGEX, "_"));
    }

    @Nonnull
    public static List<Image> getImagesFromImageId(long id2, boolean isAlbum) {
        if (id2 == 0L) {
            return List.of();
        }
        return BandcampExtractorHelper.getImagesFromImageBaseUrl(IMAGES_DOMAIN_AND_PATH + (Serializable)(isAlbum ? Character.valueOf('a') : "") + id2 + "_");
    }

    @Nonnull
    private static List<Image> getImagesFromImageBaseUrl(@Nonnull String baseUrl) {
        return IMAGE_URL_SUFFIXES_AND_RESOLUTIONS.stream().map(imageSuffix -> new Image(baseUrl + imageSuffix.getSuffix(), imageSuffix.getHeight(), imageSuffix.getWidth(), imageSuffix.getResolutionLevel())).collect(Collectors.toUnmodifiableList());
    }
}

