/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCConferenceKiosk;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.infoItems.MediaCCCStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.linkHandler.MediaCCCConferencesListLinkHandlerFactory;

public class MediaCCCSearchExtractor
extends SearchExtractor {
    private JsonObject doc;
    private MediaCCCConferenceKiosk conferenceKiosk;

    public MediaCCCSearchExtractor(StreamingService service, SearchQueryHandler linkHandler) {
        super(service, linkHandler);
        try {
            this.conferenceKiosk = new MediaCCCConferenceKiosk(service, MediaCCCConferencesListLinkHandlerFactory.getInstance().fromId("conferences"), "conferences");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nonnull
    public String getSearchSuggestion() {
        return "";
    }

    @Override
    public boolean isCorrectedSearch() {
        return false;
    }

    @Override
    @Nonnull
    public List<MetaInfo> getMetaInfo() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() {
        MultiInfoItemsCollector searchItems = new MultiInfoItemsCollector(this.getServiceId());
        if (this.getLinkHandler().getContentFilters().contains("conferences") || this.getLinkHandler().getContentFilters().contains("all") || this.getLinkHandler().getContentFilters().isEmpty()) {
            this.searchConferences(this.getSearchString(), this.conferenceKiosk.getInitialPage().getItems(), searchItems);
        }
        if (this.getLinkHandler().getContentFilters().contains("events") || this.getLinkHandler().getContentFilters().contains("all") || this.getLinkHandler().getContentFilters().isEmpty()) {
            JsonArray events = this.doc.getArray("events");
            for (int i = 0; i < events.size(); ++i) {
                if (events.getObject(i).getString("release_date") == null) continue;
                searchItems.commit(new MediaCCCStreamInfoItemExtractor(events.getObject(i)));
            }
        }
        return new ListExtractor.InfoItemsPage<InfoItem>(searchItems, null);
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) {
        return ListExtractor.InfoItemsPage.emptyPage();
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        if (this.getLinkHandler().getContentFilters().contains("events") || this.getLinkHandler().getContentFilters().contains("all") || this.getLinkHandler().getContentFilters().isEmpty()) {
            String url = this.getUrl();
            String site = downloader.get(url, this.getExtractorLocalization()).responseBody();
            try {
                this.doc = JsonParser.object().from(site);
            }
            catch (JsonParserException jpe) {
                throw new ExtractionException("Could not parse JSON.", jpe);
            }
        }
        if (this.getLinkHandler().getContentFilters().contains("conferences") || this.getLinkHandler().getContentFilters().contains("all") || this.getLinkHandler().getContentFilters().isEmpty()) {
            this.conferenceKiosk.fetchPage();
        }
    }

    private void searchConferences(String searchString, List<ChannelInfoItem> channelItems, MultiInfoItemsCollector collector) {
        for (final ChannelInfoItem item : channelItems) {
            if (!item.getName().toUpperCase().contains(searchString.toUpperCase())) continue;
            collector.commit(new ChannelInfoItemExtractor(){

                @Override
                public String getDescription() {
                    return item.getDescription();
                }

                @Override
                public long getSubscriberCount() {
                    return item.getSubscriberCount();
                }

                @Override
                public long getStreamCount() {
                    return item.getStreamCount();
                }

                @Override
                public boolean isVerified() {
                    return false;
                }

                @Override
                public String getName() {
                    return item.getName();
                }

                @Override
                public String getUrl() {
                    return item.getUrl();
                }

                @Override
                @Nonnull
                public List<Image> getThumbnails() {
                    return item.getThumbnails();
                }
            });
        }
    }
}

