/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.function.IntUnaryOperator;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudPlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudSearchExtractor
extends SearchExtractor {
    private JsonObject initialSearchObject;
    private static final String COLLECTION = "collection";
    private static final String TOTAL_RESULTS = "total_results";

    public SoundcloudSearchExtractor(StreamingService service, SearchQueryHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    @Nonnull
    public String getSearchSuggestion() {
        return "";
    }

    @Override
    public boolean isCorrectedSearch() {
        return false;
    }

    @Override
    @Nonnull
    public List<MetaInfo> getMetaInfo() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() throws IOException, ExtractionException {
        if (this.initialSearchObject.getInt(TOTAL_RESULTS) > 10) {
            return new ListExtractor.InfoItemsPage<InfoItem>(this.collectItems(this.initialSearchObject.getArray(COLLECTION)), this.getNextPageFromCurrentUrl(this.getUrl(), currentOffset -> 10));
        }
        return new ListExtractor.InfoItemsPage<InfoItem>(this.collectItems(this.initialSearchObject.getArray(COLLECTION)), null);
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) throws IOException, ExtractionException {
        int totalResults;
        JsonArray searchCollection;
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        Downloader dl = this.getDownloader();
        try {
            String response = dl.get(page.getUrl(), this.getExtractorLocalization()).responseBody();
            JsonObject result = JsonParser.object().from(response);
            searchCollection = result.getArray(COLLECTION);
            totalResults = result.getInt(TOTAL_RESULTS);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
        if (this.getOffsetFromUrl(page.getUrl()) + 10 < totalResults) {
            return new ListExtractor.InfoItemsPage<InfoItem>(this.collectItems(searchCollection), this.getNextPageFromCurrentUrl(page.getUrl(), currentOffset -> currentOffset + 10));
        }
        return new ListExtractor.InfoItemsPage<InfoItem>(this.collectItems(searchCollection), null);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        Downloader dl = this.getDownloader();
        String url = this.getUrl();
        try {
            String response = dl.get(url, this.getExtractorLocalization()).responseBody();
            this.initialSearchObject = JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
        if (this.initialSearchObject.getArray(COLLECTION).isEmpty()) {
            throw new SearchExtractor.NothingFoundException("Nothing found");
        }
    }

    private InfoItemsCollector<InfoItem, InfoItemExtractor> collectItems(JsonArray searchCollection) {
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        for (Object result : searchCollection) {
            String kind;
            if (!(result instanceof JsonObject)) continue;
            JsonObject searchResult = (JsonObject)result;
            switch (kind = searchResult.getString("kind", "")) {
                case "user": {
                    collector.commit(new SoundcloudChannelInfoItemExtractor(searchResult));
                    break;
                }
                case "track": {
                    collector.commit(new SoundcloudStreamInfoItemExtractor(searchResult));
                    break;
                }
                case "playlist": {
                    collector.commit(new SoundcloudPlaylistInfoItemExtractor(searchResult));
                }
            }
        }
        return collector;
    }

    private Page getNextPageFromCurrentUrl(String currentUrl, IntUnaryOperator newPageOffsetCalculator) throws ParsingException {
        int currentPageOffset = this.getOffsetFromUrl(currentUrl);
        return new Page(currentUrl.replace("&offset=" + currentPageOffset, "&offset=" + newPageOffsetCalculator.applyAsInt(currentPageOffset)));
    }

    private int getOffsetFromUrl(String url) throws ParsingException {
        try {
            return Integer.parseInt(Parser.compatParseMap(new URL(url).getQuery()).get("offset"));
        }
        catch (MalformedURLException e) {
            throw new ParsingException("Could not get offset from page URL", e);
        }
    }
}

