/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.nodes.Entities;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeDescriptionHelper {
    private static final String LINK_CLOSE = "</a>";
    private static final String STRIKETHROUGH_OPEN = "<s>";
    private static final String STRIKETHROUGH_CLOSE = "</s>";
    private static final String BOLD_OPEN = "<b>";
    private static final String BOLD_CLOSE = "</b>";
    private static final String ITALIC_OPEN = "<i>";
    private static final String ITALIC_CLOSE = "</i>";
    private static final Pattern LINK_CONTENT_CLEANER_REGEX = Pattern.compile("(?s)^ +[/\u2022] +(.*?) +$");

    private YoutubeDescriptionHelper() {
    }

    @Nullable
    public static String attributedDescriptionToHtml(@Nullable JsonObject attributedDescription) {
        if (Utils.isNullOrEmpty(attributedDescription)) {
            return null;
        }
        String content = attributedDescription.getString("content");
        if (content == null) {
            return null;
        }
        ArrayList<Run> openers = new ArrayList<Run>();
        ArrayList<Run> closers = new ArrayList<Run>();
        YoutubeDescriptionHelper.addAllCommandRuns(attributedDescription, openers, closers);
        YoutubeDescriptionHelper.addAllStyleRuns(attributedDescription, openers, closers);
        Collections.sort(openers, Comparator.comparingInt(run -> run.pos));
        Collections.sort(closers, Comparator.comparingInt(run -> run.pos));
        return YoutubeDescriptionHelper.runsToHtml(openers, closers, content);
    }

    static String runsToHtml(@Nonnull List<Run> openers, @Nonnull List<Run> closers, @Nonnull String rawContent) {
        String content = rawContent.replace('\u00a0', ' ');
        Stack<Run> openRuns = new Stack<Run>();
        Stack<Run> tempStack = new Stack<Run>();
        StringBuilder textBuilder = new StringBuilder();
        int currentTextPos = 0;
        int openersIndex = 0;
        int closersIndex = 0;
        while (closersIndex < closers.size()) {
            int minPos = openersIndex < openers.size() ? Math.min(closers.get((int)closersIndex).pos, openers.get((int)openersIndex).pos) : closers.get((int)closersIndex).pos;
            textBuilder.append(Entities.escape(content.substring(currentTextPos, minPos)));
            currentTextPos = minPos;
            if (closers.get((int)closersIndex).pos == minPos) {
                Run popped;
                Run closer = closers.get(closersIndex);
                ++closersIndex;
                while (!openRuns.empty()) {
                    popped = (Run)openRuns.pop();
                    if (popped.sameOpen(closer)) {
                        if (popped.transformContent != null && popped.openPosInOutput >= 0) {
                            textBuilder.replace(popped.openPosInOutput, textBuilder.length(), popped.transformContent.apply(textBuilder.substring(popped.openPosInOutput)));
                        }
                        textBuilder.append(popped.close);
                        break;
                    }
                    textBuilder.append(popped.close);
                    tempStack.push(popped);
                }
                while (!tempStack.empty()) {
                    popped = (Run)tempStack.pop();
                    textBuilder.append(popped.open);
                    openRuns.push(popped);
                }
                continue;
            }
            Run opener = openers.get(openersIndex);
            textBuilder.append(opener.open);
            opener.openPosInOutput = textBuilder.length();
            openRuns.push(opener);
            ++openersIndex;
        }
        textBuilder.append(Entities.escape(content.substring(currentTextPos)));
        return textBuilder.toString().replace("\n", "<br>").replace("  ", " &nbsp;");
    }

    private static void addAllCommandRuns(@Nonnull JsonObject attributedDescription, @Nonnull List<Run> openers, @Nonnull List<Run> closers) {
        attributedDescription.getArray("org.watermedia.shaded.commandRuns").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEach(run -> {
            JsonObject navigationEndpoint = run.getObject("onTap").getObject("innertubeCommand");
            int startIndex = run.getInt("startIndex", -1);
            int length = run.getInt("length", 0);
            if (startIndex < 0 || length < 1 || navigationEndpoint == null) {
                return;
            }
            String url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(navigationEndpoint);
            if (url == null) {
                return;
            }
            String open = "<a href=\"" + Entities.escape(url) + "\">";
            Function<String, String> transformContent = YoutubeDescriptionHelper.getTransformContentFun(run);
            openers.add(new Run(open, LINK_CLOSE, startIndex, transformContent));
            closers.add(new Run(open, LINK_CLOSE, startIndex + length, transformContent));
        });
    }

    private static Function<String, String> getTransformContentFun(JsonObject run) {
        String accessibilityLabel = run.getObject("onTapOptions").getObject("accessibilityInfo").getString("accessibilityLabel", "").replaceFirst(" Channel Link", "");
        Function<String, String> transformContent = accessibilityLabel.isEmpty() || accessibilityLabel.startsWith("YouTube: ") ? content -> {
            Matcher m = LINK_CONTENT_CLEANER_REGEX.matcher((CharSequence)content);
            if (m.find()) {
                return m.group(1);
            }
            return content;
        } : content -> accessibilityLabel;
        return transformContent;
    }

    private static void addAllStyleRuns(@Nonnull JsonObject attributedDescription, @Nonnull List<Run> openers, @Nonnull List<Run> closers) {
        attributedDescription.getArray("styleRuns").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEach(run -> {
            int start = run.getInt("startIndex", -1);
            int length = run.getInt("length", 0);
            if (start < 0 || length < 1) {
                return;
            }
            int end = start + length;
            if (run.has("strikethrough")) {
                openers.add(new Run(STRIKETHROUGH_OPEN, STRIKETHROUGH_CLOSE, start));
                closers.add(new Run(STRIKETHROUGH_OPEN, STRIKETHROUGH_CLOSE, end));
            }
            if (run.getBoolean("italic", false)) {
                openers.add(new Run(ITALIC_OPEN, ITALIC_CLOSE, start));
                closers.add(new Run(ITALIC_OPEN, ITALIC_CLOSE, end));
            }
            if (run.has("weightLabel") && !"FONT_WEIGHT_NORMAL".equals(run.getString("weightLabel"))) {
                openers.add(new Run(BOLD_OPEN, BOLD_CLOSE, start));
                closers.add(new Run(BOLD_OPEN, BOLD_CLOSE, end));
            }
        });
    }

    static final class Run {
        @Nonnull
        final String open;
        @Nonnull
        final String close;
        final int pos;
        @Nullable
        final Function<String, String> transformContent;
        int openPosInOutput = -1;

        Run(@Nonnull String open, @Nonnull String close, int pos) {
            this(open, close, pos, null);
        }

        Run(@Nonnull String open, @Nonnull String close, int pos, @Nullable Function<String, String> transformContent) {
            this.open = open;
            this.close = close;
            this.pos = pos;
            this.transformContent = transformContent;
        }

        public boolean sameOpen(@Nonnull Run other) {
            return this.open.equals(other.open);
        }
    }
}

