/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.suggestion;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;

public abstract class SuggestionExtractor {
    private final StreamingService service;
    @Nullable
    private Localization forcedLocalization;
    @Nullable
    private ContentCountry forcedContentCountry;

    public SuggestionExtractor(StreamingService service) {
        this.service = service;
    }

    public abstract List<String> suggestionList(String var1) throws IOException, ExtractionException;

    public int getServiceId() {
        return this.service.getServiceId();
    }

    public StreamingService getService() {
        return this.service;
    }

    public void forceLocalization(@Nullable Localization localization) {
        this.forcedLocalization = localization;
    }

    public void forceContentCountry(@Nullable ContentCountry contentCountry) {
        this.forcedContentCountry = contentCountry;
    }

    @Nonnull
    public Localization getExtractorLocalization() {
        return this.forcedLocalization == null ? this.getService().getLocalization() : this.forcedLocalization;
    }

    @Nonnull
    public ContentCountry getExtractorContentCountry() {
        return this.forcedContentCountry == null ? this.getService().getContentCountry() : this.forcedContentCountry;
    }
}

