/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.SeatBlock;
import com.starfish_studios.yaf.block.entity.ChairBlockEntity;
import com.starfish_studios.yaf.block.properties.ChangeableBlock;
import com.starfish_studios.yaf.block.properties.Cushionable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChairBlock
extends SeatBlock
implements SimpleWaterloggedBlock,
ChangeableBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty BACK = BooleanProperty.m_61465_((String)"back");
    public static final VoxelShape BOTTOM_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0)});
    public static final VoxelShape CUSHION_AABB = Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
    public static final VoxelShape BOTTOM_WITHOUT_CUSHION = BOTTOM_AABB;
    public static final VoxelShape BOTTOM_WITH_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)CUSHION_AABB);
    public static final VoxelShape NORTH_AABB = Block.m_49796_((double)2.0, (double)10.0, (double)13.0, (double)14.0, (double)22.0, (double)15.0);
    public static final VoxelShape NORTH_WITHOUT_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_WITHOUT_CUSHION, (VoxelShape)NORTH_AABB);
    public static final VoxelShape NORTH_WITH_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_WITH_CUSHION, (VoxelShape)NORTH_AABB);
    public static final VoxelShape EAST_AABB = Block.m_49796_((double)1.0, (double)10.0, (double)2.0, (double)3.0, (double)22.0, (double)14.0);
    public static final VoxelShape EAST_WITHOUT_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_WITHOUT_CUSHION, (VoxelShape)EAST_AABB);
    public static final VoxelShape EAST_WITH_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_WITH_CUSHION, (VoxelShape)EAST_AABB);
    public static final VoxelShape SOUTH_AABB = Block.m_49796_((double)2.0, (double)10.0, (double)1.0, (double)14.0, (double)22.0, (double)3.0);
    public static final VoxelShape SOUTH_WITHOUT_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_WITHOUT_CUSHION, (VoxelShape)SOUTH_AABB);
    public static final VoxelShape SOUTH_WITH_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_WITH_CUSHION, (VoxelShape)SOUTH_AABB);
    public static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)10.0, (double)2.0, (double)15.0, (double)22.0, (double)14.0);
    public static final VoxelShape WEST_WITHOUT_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_WITHOUT_CUSHION, (VoxelShape)WEST_AABB);
    public static final VoxelShape WEST_WITH_CUSHION = Shapes.m_83110_((VoxelShape)BOTTOM_WITH_CUSHION, (VoxelShape)WEST_AABB);

    public ChairBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BACK, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!((Boolean)state.m_61143_((Property)BACK)).booleanValue()) {
            return BOTTOM_WITHOUT_CUSHION;
        }
        return switch (facing) {
            case Direction.NORTH -> NORTH_WITHOUT_CUSHION;
            case Direction.EAST -> EAST_WITHOUT_CUSHION;
            case Direction.SOUTH -> SOUTH_WITHOUT_CUSHION;
            case Direction.WEST -> WEST_WITHOUT_CUSHION;
            default -> BOTTOM_AABB;
        };
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.tryChangeBlock((Property<?>)BACK, state, (LevelAccessor)level, pos, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public boolean tryChangeBlock(Property<?> property, BlockState state, LevelAccessor level, BlockPos pos, Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        boolean success = ChangeableBlock.super.tryChangeBlock(property, state, level, pos, player, hand);
        if (success && (blockEntity = level.m_7702_(pos)) instanceof ChairBlockEntity) {
            ChairBlockEntity entity = (ChairBlockEntity)blockEntity;
            entity.setHasBack((Boolean)state.m_61143_((Property)BACK) == false);
        }
        return success;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Cushionable) {
            Cushionable cushionable = (Cushionable)blockEntity;
            cushionable.dropCarpet(level, pos);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.m_61104_(new Property[]{FACING, WATERLOGGED, BACK});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.4f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos.m_121945_((Direction)state.m_61143_((Property)FACING));
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122435_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChairBlockEntity(pos, state);
    }
}

